/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logagent.util;

import org.apache.log4j.Logger;

/**
 * 内部エラーの出力用ユーティリティクラス<BR>
 * 
 * ログはlog4jを使って出力されます<BR>
 * 
 * @version 2.4.3
 * @since 2.4.3
 */
public class InternalLogger {

	/** ロガー（Log4J） */
	static Logger log = Logger.getLogger("hinemos.internal.log"); 
	
	/**
	 * プライオリティ「INFO」でログを出力します
	 * 
	 * @param message the message object to log. 
	 */
	public static void info(Object message) {
		log.info(message);
	}

	/**
	 * プライオリティ「WARN」でログを出力します
	 * 
	 * @param message the message object to log. 
	 */
	public static void warn(Object message) {
		log.warn(message);
	}

	/**
	 * プライオリティ「ERROR」でログを出力します
	 * 
	 * @param message the message object to log. 
	 */
	public static void error(Object message) {
		log.error(message);
	}
	
	/**
	 * プライオリティ「FATAL」でログを出力します
	 * 
	 * @param message the message object to log. 
	 */
	public static void fatal(Object message) {
		log.fatal(message);
	}
}