/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;


/**
 * ジョブ待ち条件ジョブマスタのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobStartJobMaster"
 *           jndi-name="JobStartJobMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAOImpl
 */
public abstract class JobStartJobMasterBean implements javax.ejb.EntityBean {
    /** ジョブID */
    protected String job_id;
    /** 判定対象ジョブID */
    protected String target_job_id;
    /** 判定対象種別 */
    protected Integer target_job_type;
    /** 値 */
    protected Integer target_job_end_value;
    
    /**
     * ジョブ待ち条件ジョブマスタを生成します。
     * 
     * @ejb.create-method 
     * 
     * @param job_id ジョブID
     * @param target_job_id 判定対象ジョブID
     * @param target_job_type 判定対象種別
     * @param target_job_end_value 値
     * @return プライマリキー
     * @throws javax.ejb.CreateException
     * 
     * @see com.clustercontrol.bean.JudgmentObjectConstant
     */
    public JobStartJobMasterPK ejbCreate(
            String job_id, 
            String target_job_id, 
            Integer target_job_type, 
            Integer target_job_end_value
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.target_job_id = target_job_id;
        this.target_job_type = target_job_type;
        this.target_job_end_value = target_job_end_value;
        return null;
    }

	/**
	 * 全てのジョブ待ち条件ジョブマスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブ待ち条件ジョブマスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAOImpl#findByPrimaryKey(JobStartJobMasterPK)
	 */
	public JobStartJobMasterPK ejbFindByPrimaryKey(JobStartJobMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * ジョブIDに一致するジョブ待ち条件ジョブマスタを検索します。
	 * 
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAOImpl#findByJobId(String)
	 */
	public Collection ejbFindByJobId(java.lang.String job_id) throws FinderException {
		return null;
	}

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
    public java.lang.String getJob_id() {
    	return job_id;
    }

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

	/**
	 * 判定対象ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 判定対象ジョブID
	 */
    public java.lang.String getTarget_job_id() {
    	return target_job_id;
    }

	/**
	 * 判定対象ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param target_job_id 判定対象ジョブID
	 */
    public void setTarget_job_id(java.lang.String target_job_id) {
    	this.target_job_id = target_job_id;
    }

	/**
	 * 判定対象種別を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 判定対象種別
	 * 
	 * @see com.clustercontrol.bean.JudgmentObjectConstant
	 */
    public java.lang.Integer getTarget_job_type() {
    	return target_job_type;
    }

	/**
	 * 判定対象種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param target_job_type 判定対象種別
	 * 
	 * @see com.clustercontrol.bean.JudgmentObjectConstant
	 */
    public void setTarget_job_type(
            java.lang.Integer target_job_type) {
    	this.target_job_type = target_job_type;
    }
    
	/**
	 * 値を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 値
	 */
    public java.lang.Integer getTarget_job_end_value() {
    	return target_job_end_value;
    }

	/**
	 * 値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param target_job_end_value 値
	 */
    public void setTarget_job_end_value(
            java.lang.Integer target_job_end_value) {
    	this.target_job_end_value = target_job_end_value;
    }

	/**
	 * ジョブ待ち条件マスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ待ち条件マスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterBean#ejbFindByPrimaryKey(JobStartMasterPK)
	 */
    public JobStartMasterLocal getJobStartMaster() {
    	JobStartMasterLocal jobStartMaster = null;
		try {
			jobStartMaster = JobStartMasterUtil.getLocalHome().findByPrimaryKey(new JobStartMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartMaster;
	}
}
