/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.logtransfer.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import com.clustercontrol.logtransfer.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ログ転送情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.1.0
 */
public class GetLogTransfer {
	
	/**
	 * ログ転送情報を返します。
	 * 
	 * @param transferId ログ転送ID
	 * @return ログ転送情報
	 */
	public LogTransferInfo getLogTransfer(String transferId) {
		
		LogTransferController logTransfer = EjbConnectionManager.getConnectionManager()
		.getLogTransferController();
		
		LogTransferInfo info = null;
		try {
			info = logTransfer.getLogTransfer(transferId);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return info;
	}
	
	/**
	 * ログ転送一覧を返します。
	 * 
	 * @return ログ転送一覧
	 */
	public ArrayList getLogTransferList() {
		
		LogTransferController logTransfer = EjbConnectionManager.getConnectionManager()
		.getLogTransferController();
		
		ArrayList records = null;
		try {
			records = logTransfer.getLogTransferList();
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return records;
	}
}