/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.clustercontrol.bean.CommonTableTreeItem;

/**
 * CommonTableTreeViewerクラス用のContentProviderクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommonTableTreeContentProvider implements ITreeContentProvider {

    /**
     * @param element
     * @return
     */
    public Object getParent(Object element) {
        return ((CommonTableTreeItem) element).getParent();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
     */
    public Object[] getElements(Object inputElement) {
        return getChildren(inputElement);
    }

    /**
     * @param parentElement
     * @return
     */
    public Object[] getChildren(Object parentElement) {
        return ((CommonTableTreeItem) parentElement).getChildren();
    }

    /**
     * @param element
     * @return
     */
    public boolean hasChildren(Object element) {
        return ((CommonTableTreeItem) element).size() > 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
     *      java.lang.Object, java.lang.Object)
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.IContentProvider#dispose()
     */
    public void dispose() {
    }
}