/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * カレンダ予定を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetCalendarSchedule {

    // ----- instance メソッド ----- //

    /**
     * 全てのカレンダ予定を取得します。<BR>
     * 
     * @return カレンダ予定
     */
    public ArrayList getAll(Date base) {
		CalendarController calendar = 
			EjbConnectionManager.getConnectionManager().getCalendarController();
		

        ArrayList records = null;
        try {
            records = calendar.getSchedule(base);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}