/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * カレンダ曜日別情報を登録するクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.0.0
 */
public class AddWeekdayInfoProperty {
	
	/**
	 * 指定したカレンダ曜日別情報を追加します。<BR>
	 * 
	 * @param property 属性情報
	 * @return 登録に成功した場合、true
	 */
	public boolean add(String id, Property property) {
    	Property copy = PropertyUtil.copy(property);
        PropertyUtil.deletePropertyDefine(copy);
        
        CalendarController calendar = 
			EjbConnectionManager.getConnectionManager().getCalendarController();
		
		boolean result = false;
		try {
			calendar.addWeekday(id, copy);
			result = true;
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (NamingException e) {
		} catch (CreateException e) {
			if(e instanceof DuplicateKeyException){
				// 実行規則が重複している場合、エラーダイアログを表示する
	            MessageDialog.openInformation(
	            		null, 
	            		Messages.getString("message"),
	                    Messages.getString("message.calendar.28"));
	            return result;
			}
		} catch (FinderException e) {
		}
		
		if(result){
        	MessageDialog.openInformation(
        			null, 
        			Messages.getString("successful"), 
        			Messages.getString("message.calendar.8"));
		}
		else{
        	MessageDialog.openError(
        			null, 
        			Messages.getString("failed"), 
        			Messages.getString("message.calendar.9"));
		}
    	
    	return result;
	}
}