/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.audit.log.util;

import java.security.Principal;

import org.jboss.security.SecurityAssociation;

/**
 * ユーザ名用ログメッセージ生成クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 */
public class UserName extends LogMessageDecorator {

	/**
	 * コンストラクタ
	 * 
	 * @param component LogMessageComponentオブジェクト
	 */
	public UserName(LogMessageComponent component) {
		super(component);
	}

	/**
	 * ユーザ名を取得し、ログメッセージを作成する
	 * 
	 * @return ログメッセージ
	 * @see com.clustercontrol.audit.log.util.LogMessageDecorator#getLogMessage()
	 */
	@Override
	public String getLogMessage() throws Exception {
		String name = ", User=";
		try {
			// ユーザの接続元を設定する
			String remoteAddr = Thread.currentThread().getName();
			
			// ユーザ名を取得する
			Principal pri = SecurityAssociation.getCallerPrincipal();
			if(pri instanceof Principal){
				
				if(remoteAddr.matches("^WorkerThread.*")){
					//ログインユーザの場合、WorkerThread#3[10.68.1.43:4988]の様な形式を整形
					remoteAddr = remoteAddr.substring(remoteAddr.indexOf("["));
				}else{
					
				}
				
				name = name + pri.getName() + "@" + remoteAddr;
				
			// Hinemosログインユーザからの操作で無い場合(ジョブのSchedule起動など)
			}else{
				name = name + "HinemosInternal";
			}
			
		} catch (Exception e) {
			throw e;
		}
		return name + super.getLogMessage();
	}
}
