/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.audit.log;

import org.jboss.aop.Aspect;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.MethodInvocation;

import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;

/**
 * メンテナンス機能 操作ログ出力クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 * @see com.clustercontrol.audit.log.Logger
 */
@Aspect (scope= Scope.PER_VM)
public class Maintenance extends Logger {

	/**
	 * メンテナンス設定追加時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.maintenance.ejb.session.MaintenanceControllerBean->addMaintenance(..))")
	public Object addMaintenanceAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Maintenance] Add";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof MaintenanceInfoDataImp){
			MaintenanceInfoDataImp info = (MaintenanceInfoDataImp)args[0];
			msg.append(", MaintenanceID=");
			msg.append(info.getMaintenance_id());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * メンテナンス設定変更時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.maintenance.ejb.session.MaintenanceControllerBean->modifyMaintenance(..))")
	public Object modifyMaintenanceAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Maintenance] Change";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof MaintenanceInfoDataImp){
			MaintenanceInfoDataImp info = (MaintenanceInfoDataImp)args[0];
			msg.append(", MaintenanceID=");
			msg.append(info.getMaintenance_id());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * メンテナンス設定削除時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.maintenance.ejb.session.MaintenanceControllerBean->deleteMaintenance(..))")
	public Object deleteMaintenanceAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Maintenance] Delete";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof String){
			msg.append(", MaintenanceID=");
			msg.append((String)args[0]);
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}
}
