/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeKeeperService {
	private static Log m_log = LogFactory.getLog( TimeKeeperService.class );
	
	private static String LDAP_CONNECT_MAXSIZE_PROPERTY = "com.sun.jndi.ldap.connect.pool.maxsize";
	private static String LDAP_TIMEOUT = "common.ldap.timeout";
	private static String LDAP_TIMEKEEPER_THREAD_COUNT = "common.ldap.timekeeper.thread.count";
	
    private static ExecutorService exes;
    private static long timeout = 15000l;
    
    static {
    	// プロパティを設定
    	Properties properties = new Properties();

		try {
			String homedir = System.getProperty("jboss.server.home.dir");
			String propertyFile = homedir + File.separator + "conf"
					+ File.separator + "ldap-timeout.properties";
			properties.load(new FileInputStream(propertyFile));
		} catch (Exception e) {
			m_log.debug(e.getMessage());
		}

		// タイムアウト時間を設定
    	try{
    		timeout = Integer.parseInt(properties.getProperty(LDAP_TIMEOUT));
		} catch (Exception e) {
			// ignore and continue
			// デフォルトの15000msとなる
		}
		
		// プールする最大スレッド数を設定
    	int threadSize = 10;
		
    	try{
    		threadSize = Integer.parseInt(properties.getProperty(LDAP_TIMEKEEPER_THREAD_COUNT));
		} catch (Exception e) {
			// プロパティファイルから読めない場合はLDAPアクセスの設定から値を求める
	    	String conMaxSizeString = System.getProperty(LDAP_CONNECT_MAXSIZE_PROPERTY);

	    	try{
	    		threadSize = Integer.parseInt(conMaxSizeString);
			} catch (Exception e1) {
				// ignore and continue
				// デフォルトの10となる
			}
		}
    		
		m_log.info("LDAP TimeKeeperThread ThreadPoolSize : " + threadSize);
    	TimeKeeperThreadFactory threadFactory = new TimeKeeperThreadFactory();
    	exes = Executors.newFixedThreadPool(threadSize, threadFactory);
    }
    
	public static TimeKeeper start() {
		TimeKeeper keeper = new TimeKeeper(timeout);

		exes.execute(keeper);
		return keeper;
	}
	
	public static void stop(TimeKeeper timeKeeper) {
		timeKeeper.stop();

		// TimeKeeperスレッドが停止後に実行する必要あり
		// このメソッドが呼べるということは呼び出しもとスレッドは走行中
		// 割り込まれている場合はその割り込みを解消
		Thread.interrupted();
	}
	
	static private class TimeKeeperThreadFactory implements ThreadFactory {

		public Thread newThread(Runnable r) {
			return new Thread(r, Thread.currentThread().getName() + "-TimeKeeper");
		}
		
	}
}
