/*
 
 Copyright (C) 2008 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import java.lang.reflect.Field;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * メールテンプレートの変数情報を定義するクラス<BR>
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class NotifySubstitutionParameterConstant {
	/** イベント出力の重要度 */
	public static final String PRIORITY = "${PRIORITY}";
	/** イベント出力の重要度（正規表現） */
	public static final String PRIORITY_REGEX = "\\$\\{PRIORITY\\}";
	/** イベント出力の重要度　日本語 */
	public static final String PRIORITY_JP = "${PRIORITY_JP}";
	/** イベント出力の重要度　日本語（正規表現） */
	public static final String PRIORITY_JP_REGEX = "\\$\\{PRIORITY_JP\\}";	
	/** イベント出力の重要度 英語 */
	public static final String PRIORITY_EN = "${PRIORITY_EN}";
	/** イベント出力の重要度　英語（正規表現） */
	public static final String PRIORITY_EN_REGEX = "\\$\\{PRIORITY_EN\\}";
	/** イベント出力の重要度 数値*/
	public static final String PRIORITY_NUM = "${PRIORITY_NUM}";
	/** イベント出力の重要度　数値（正規表現） */
	public static final String PRIORITY_NUM_REGEX = "\\$\\{PRIORITY_NUM\\}";
	/** イベント出力の出力日時 */
	public static final String GENERATION_DATE = "${GENERATION_DATE}";
	/** イベント出力の出力日時（正規表現） */
	public static final String GENERATION_DATE_REGEX = "\\$\\{GENERATION_DATE\\}";
	/** イベント出力のプラグインID */
	public static final String PLUGIN_ID = "${PLUGIN_ID}";
	/** イベント出力のプラグインID（正規表現） */
	public static final String PLUGIN_ID_REGEX = "\\$\\{PLUGIN_ID\\}";
	/** イベント出力の監視項目ID */
	public static final String MONITOR_ID = "${MONITOR_ID}";
	/** イベント出力の監視項目ID（正規表現） */
	public static final String MONITOR_ID_REGEX = "\\$\\{MONITOR_ID\\}";
	/** イベント出力のファシリティID */
	public static final String FACILITY_ID = "${FACILITY_ID}";
	/** イベント出力のファシリティID（正規表現） */
	public static final String FACILITY_ID_REGEX = "\\$\\{FACILITY_ID\\}";
	/** イベント出力のスコープ */
	public static final String SCOPE = "${SCOPE}";
	/** イベント出力のスコープ（正規表現） */
	public static final String SCOPE_REGEX = "\\$\\{SCOPE\\}";
	/** イベント出力のアプリケーション */
	public static final String APPLICATION = "${APPLICATION}";
	/** イベント出力のアプリケーション（正規表現） */
	public static final String APPLICATION_REGEX = "\\$\\{APPLICATION\\}";
	/** イベント出力のメッセージID */
	public static final String MESSAGE_ID = "${MESSAGE_ID}";
	/** イベント出力のメッセージID（正規表現） */
	public static final String MESSAGE_ID_REGEX = "\\$\\{MESSAGE_ID\\}";
	/** イベント出力のメッセージ */
	public static final String MESSAGE = "${MESSAGE}";
	/** イベント出力のメッセージ（正規表現） */
	public static final String MESSAGE_REGEX = "\\$\\{MESSAGE\\}";
	/** イベント出力のオリジナルメッセージ */
	public static final String ORG_MESSAGE = "${ORG_MESSAGE}";
	/** イベント出力のオリジナルメッセージ（正規表現） */
	public static final String ORG_MESSAGE_REGEX = "\\$\\{ORG_MESSAGE\\}";
	/** イベント出力のIPアドレス */
	public static final String IP_ADDRESS = "${IP_ADDRESS}";
	/** イベント出力のIPアドレス（正規表現） */
	public static final String IP_ADDRESS_REGEX = "\\$\\{IP_ADDRESS\\}";
	/** イベント出力のノード名 */
	public static final String NODE = "${NODE}";
	/** イベント出力のノード名（正規表現） */
	public static final String NODE_REGEX = "\\$\\{NODE\\}";
	
	/** ジョブ変数 ヘッダー */
	public static final String HEADER = "${";
	/** ジョブ変数 ヘッダー 正規表現 */
	public static final String HEADER_REGEX = "\\$\\{";
	/** ジョブ変数 フッター */
	public static final String FOOTER = "}";
	/** ジョブ変数 フッター 正規表現 */
	public static final String FOOTER_REGEX = "\\}";
	
	public static String[] parameters = null;
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( NotifySubstitutionParameterConstant.class );

	
	/** フィールドに設定されている文字列の配列を返します。
	 * @return フィールドに設定されている文字列の配列
	 */
	public synchronized static String[] getParameterList() {
		
		// parametersがnullの場合のみ実行（最初の1回のみ）
		if (parameters == null) {
			ArrayList<String> list = new ArrayList<String>();

			// フィールド情報の取得
			Field[] fields = NotifySubstitutionParameterConstant.class.getFields();

			for (int i = 0; i < fields.length; i++) {
				Field field = fields[i];
				
				// フィールドの情報がStringクラスの場合のみ
				if (field.getType().isAssignableFrom(String.class)) {
					
					// フィールド名に「REGEX」を含まない場合のみ
					if (field.getName().indexOf("REGEX") == -1) {
						try {
							// フィールドの値を取得
							String value = (String) field
									.get(NotifySubstitutionParameterConstant.class);

							// 取得した値が「${」で始まり、「}」で終わる場合のみリストに追加
							if (value.startsWith(HEADER)
									&& value.endsWith(FOOTER)) {
								list.add(value);
							}
						} catch (IllegalArgumentException e) {
							m_log.error("getParameterList(): ",e);
						} catch (IllegalAccessException e) {
							m_log.error("getParameterList(): ",e);
						}
					}
				}
			}
			
			// ArayListをStringの配列に変換
			parameters = list.toArray(new String[0]);
		}

		return parameters;
	}
}