/*
 * Generated by XDoclet - Do not edit!
 */
package com.clustercontrol.performance.ejb.session;

/**
 * Remote interface for CollectorController.
 * @since 1.0 <!-- begin-xdoclet-definition -->
 * @generated 
 * @xdoclet-generated at ${TODAY}
 * @copyright The XDoclet Team
 * @author XDoclet
 * @version 3.2.1
 */
public interface CollectorController
   extends javax.ejb.EJBObject
{
   /**
    * リアルタイム収集用のEntityBeanを生成します。
    * @param facilityID ファシリティID
    * @param interval 収集間隔
    * @param colletorItemList　収集項目設定のリスト
    */
   public void createRealtimeColletor( java.lang.String facilityID,int interval,java.util.List colletorItemList )
      throws java.rmi.RemoteException;

   /**
    * 指定スコープのリアルタイム収集の収集済みデータを取得します。
    * @param facilityID ファシリティID
    * @param itemID　収集項目ID
    * @return　収集済み性能データ（CollectedDataInfo）のリスト 
    */
   public java.util.Collection getRealtimeCollectedData( java.lang.String facilityID,java.lang.String itemCode,java.lang.String displayName )
      throws java.rmi.RemoteException;

   /**
    * 指定スコープのサブスコープのリアルタイム収集済みデータを取得します。
    * @param facilityID ファシリティID
    * @param itemID　収集項目ID
    * @return　収集済み性能データ（CollectedDataInfo）のリスト 
    */
   public java.util.Collection getSubScopeRealtimeCollectedData( java.lang.String facilityID,java.lang.String itemCode,java.lang.String displayName )
      throws java.rmi.RemoteException;

   /**
    * リアルタイム収集の収集済みデータを取得します。 指定のファシリティで収集されている全ての収集項目の性能値データを取得します。
    * @param facilityID　ファシリティID
    * @return 収集済み性能データ（CollectedDataInfo）のリスト
    */
   public java.util.Collection getRealtimeCollectedDataAll( java.lang.String facilityID )
      throws java.rmi.RemoteException;

   /**
    * 収集設定のプロパティ情報を取得します（指定の収集IDが存在しない場合はnullを返す）。
    * @param collectorID 収集ID
    * @return 収集設定のプロパティ情報
    */
   public com.clustercontrol.performance.bean.CollectorProperty getCollectorProperty( java.lang.String collectorID )
      throws java.rmi.RemoteException;

   /**
    * 実績情報収集用のEntityBeanを生成し、収集を開始します。
    * @param collectorDef　収集の定義情報
    */
   public void createRecordColletor( com.clustercontrol.performance.bean.CollectorProperty collectorDef )
      throws javax.ejb.DuplicateKeyException, java.rmi.RemoteException;

   /**
    * 実績収集を停止します。
    * @param collectorID 停止したい収集ID
    */
   public void stopRecordCollector( java.lang.String collectorID )
      throws java.rmi.RemoteException;

   /**
    * 実績収集で収集されたデータを取得します。
    * @param collectorID 収集ID
    * @param facilityID　ファシリティID
    * @param item　収集項目
    * @param startDate　取得したい始点の時刻
    * @param endDate　　取得した終点の時刻
    * @return　収集済み性能データ（CollectedDataInfo）のリスト 
    */
   public java.util.List getRecordCollectedData( com.clustercontrol.performance.bean.CollectorItemInfo item,java.lang.String facilityID,java.util.Date startDate,java.util.Date endDate )
      throws java.rmi.RemoteException;

   /**
    * 実績収集結果を収集ID、ファシリティID、検索期間（開始日時および終了日時）の組み合わせで検索し、収集性能値DTOクラスの配列として返す。
    * @param collectorID 収集ID
    * @param facilityID ファシリティID
    * @param startDate 検索対象となる開始日時
    * @param endDate 検索対象となる終了日時
    * @return 該当する収集性能値DTOクラスの配列（順序は収集日時順とは限らない）
    */
   public java.util.List getRecordCollectedData( java.lang.String collectorID,java.lang.String facilityID,java.util.Date startDate,java.util.Date stopDate )
      throws java.rmi.RemoteException;

   /**
    * 実績収集で収集されたデータを取得します。
    * @param facilityID　ファシリティIDの配列
    * @param itemInfos　収集項目の配列
    * @param startDate　取得したい始点の時刻
    * @param endDate　　取得した終点の時刻
    * @return　収集データのデータセット 
    */
   public com.clustercontrol.performance.bean.CollectedDataSet getRecordCollectedData( java.lang.String[] facilityIDs,com.clustercontrol.performance.bean.CollectorItemInfo[] itemInfos,java.util.Date startDate,java.util.Date endDate )
      throws java.rmi.RemoteException;

   /**
    * 実績収集設定及び、収集した性能情報を全て削除します。
    * @param collectorID　削除したい収集ID
    */
   public void deleteRecordCollector( java.lang.String collectorID )
      throws javax.ejb.RemoveException, java.rmi.RemoteException;

   /**
    * 収集設定時のファシリティツリー情報を取得します。
    * @param collectorID 収集ID
    * @return FacilityTreeItem ファシリティツリー
    */
   public com.clustercontrol.bean.FacilityTreeItem getFacilityTree( java.lang.String collectorID )
      throws java.rmi.RemoteException;

   /**
    * 現在のリポジトリに登録されているデバイス情報から 指定のファシリティID以下の階層のノードのデバイスのリストを取得します。
    * @param ファシリティID
    * @return デバイス情報のセット
    */
   public com.clustercontrol.performance.bean.DeviceDataSet getCurrentDeviceSet( java.lang.String facilityID )
      throws java.rmi.RemoteException;

   /**
    * 収集設定に含まれたファシリティのデバイス情報を取得します。
    * @param collectorID　収集ID
    * @return デバイス情報のセット
    */
   public com.clustercontrol.performance.bean.DeviceDataSet getDeviceSet( java.lang.String collectorId )
      throws javax.ejb.FinderException, javax.naming.NamingException, java.rmi.RemoteException;

   /**
    * 指定の収集IDのデータに対して削除ロックをかけます。
    */
   public void lock( java.lang.String collectorID,com.clustercontrol.performance.bean.CollectorLockKey key )
      throws java.rmi.RemoteException;

   /**
    * 指定の収集IDのデータに対する削除ロックを解除します。
    */
   public void unlock( com.clustercontrol.performance.bean.CollectorLockKey key )
      throws java.rmi.RemoteException;

   /**
    * 実績収集のリストを返します。 戻り値のArrayListはArrayLisyのArrayListとなる。 　実行状態、ステータス、収集ID、説明、スコープのパス、収集開始時刻、収集終了時刻、収集間隔、収集回数 　が格納されているArrayListのリストとなる。 下記のような構造。 　インデックス1:実行状態、ステータス、収集ID、説明、スコープのパス、収集開始時刻、収集終了時刻、収集間隔、収集回数 　インデックス2:実行状態、ステータス、収集ID、説明、スコープのパス、収集開始時刻、収集終了時刻、収集間隔、収集回数 　インデックス3:実行状態、ステータス、収集ID、説明、スコープのパス、収集開始時刻、収集終了時刻、収集間隔、収集回数 　インデックス4:実行状態、ステータス、収集ID、説明、スコープのパス、収集開始時刻、収集終了時刻、収集間隔、収集回数 …
    * @generated 
    * @return 実績収集の一覧（Objectの2次元配列）
    * @throws NamingException
    * @throws FinderException    */
   public java.util.ArrayList getCollectionList(  )
      throws java.rmi.RemoteException;

   /**
    * 収集項目コードの一覧を取得します
    * @generated 
    * @return 収集項目IDをキーとしCollectorItemTreeItemが格納されているHashMap    */
   public java.util.HashMap getItemCodeMap(  )
      throws java.rmi.RemoteException;

   /**
    * 収集項目ツリーを返します
    * @generated 
    * @param facilityId ファシリティID
    * @param collectorId 収集ID
    * @return 収集項目ツリー（GUIで収集項目をカテゴリ毎にツリー構造で表示するためのデータ構造）    */
   public com.clustercontrol.performance.util.code.CollectorItemTreeItem[] getCollectorTree( java.lang.String facilityId,java.lang.String collectorId )
      throws java.rmi.RemoteException;

   /**
    * 指定のファシリティで収集可能な項目のリストを返します デバイス別の収集項目があり、ノード毎に登録されているデバイス情報が異なるため、 取得可能な収集項目はファシリティ毎に異なる。
    * @generated 
    * @param facilityId ファシリティID
    * @return 指定のファシリティで収集可能な項目のリスト    */
   public java.util.List getAvailableCollectorItemList( java.lang.String facilityId )
      throws java.rmi.RemoteException;

   /**
    * アクセス可能かどうかをチェックするためのメソッド 読み込み権限のあるroleで呼び出すとtrueを返す
    * @generated 
    * @return true    */
   public boolean checkPermissionRead(  )
      throws java.rmi.RemoteException;

   /**
    * アクセス可能かどうかをチェックするためのメソッド 書き込み権限のあるroleで呼び出すとtrueを返す
    * @generated 
    * @return true    */
   public boolean checkPerformanceWrite(  )
      throws java.rmi.RemoteException;

   /**
    * アクセス可能かどうかをチェックするためのメソッド 書き込み権限のあるroleで呼び出すとtrueを返す
    * @generated 
    * @return true    */
   public boolean checkPermissionExecute(  )
      throws java.rmi.RemoteException;

   /**
    * 指定のファシリティIDが収集設定で使用されているかチェックします。 <P> 使用されていたら、UsedFacilityException がスローされる。
    * @param facilityId ファシリティ
    * @throws UsedFacilityException
    * @see com.clustercontrol.commons.ejb.session.CheckFacility#isUseFacilityId(java.lang.String)
    * @see com.clustercontrol.bean.PluginConstant;    */
   public void isUseFacilityId( java.lang.String facilityId )
      throws com.clustercontrol.UsedFacilityException, java.rmi.RemoteException;

   /**
    * 実績情報収集用のEntityBeanを生成し、収集を一時停止します。
    * @param collectorId　収集ID
    */
   public void suspendCollect( java.lang.String collectorId )
      throws java.rmi.RemoteException;

   /**
    * 実績情報収集用のEntityBeanを生成し、収集を再開します。
    * @param collectorId　収集ID
    */
   public void restartCollect( java.lang.String collectorId )
      throws java.rmi.RemoteException;

   /**
    * 指定の収集を設定した際の実績収集データのサイズを見積ります。 （見積りだけで実際に収集は設定されません）
    * @return 見積り結果（見積りに失敗した場合は、-1を返します）
    */
   public long getEstimation( com.clustercontrol.performance.bean.CollectorProperty property )
      throws java.rmi.RemoteException;

}
