/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.process.ejb.session.MonitorProcessControllerLocal;
import com.clustercontrol.process.ejb.session.MonitorProcessControllerUtil;

@javax.jws.WebService
public class MonitorProcessEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorProcessEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorProcessControllerLocal getMonitorProcessControllerLocal() throws HinemosUnknownException {
		MonitorProcessControllerLocal monitor = null;
		try {
			monitor = MonitorProcessControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorProcessControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorProcessControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * プロセス監視情報をマネージャに登録します。<BR>
	 * 
	 * @param info 通知情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorDuplicateException
	 * @throws HinemosUnknownException 
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean addProcessMonitor(MonitorInfo info) throws MonitorDuplicateException, HinemosUnknownException{
		MonitorProcessControllerLocal monitor = getMonitorProcessControllerLocal();
		return monitor.addProcess(info);
	}
	
	/**
	 * マネージャのプロセス監視情報を更新します。<BR>
	 * 
	 * @param info 通知情報
	 * @return 変更に成功した場合、true
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean modifyProcessMonitor(MonitorInfo info) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorProcessControllerLocal monitor = getMonitorProcessControllerLocal();
		return monitor.modifyProcess(info);
	}

	/**
	 * プロセス監視情報マネージャから削除します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public boolean deleteProcessMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorProcessControllerLocal monitor = getMonitorProcessControllerLocal();
		return monitor.deleteProcess(monitorId);
	}
	
	/**
	 * プロセス監視情報を取得します。<BR>
	 * 
	 * 引数に指定されたmonitorIdに対応するプロセス監視設定情報を取得します。
	 * 
	 * @param monitorId 状態監視ID
	 * @return プロセス監視情報
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public MonitorInfo getProcessMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException{
		MonitorProcessControllerLocal monitor = getMonitorProcessControllerLocal();
		return monitor.getProcess(monitorId);
	}

	/**
	 * プロセス監視一覧リストを取得します。<BR>
	 * 
	 * @return MonitorInfoの配列
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public ArrayList<MonitorInfo> getProcessList() throws MonitorNotFoundException, HinemosUnknownException{
		MonitorProcessControllerLocal monitor = getMonitorProcessControllerLocal();
		return monitor.getProcessList();
	}
	
}
