/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingControllerLocal;
import com.clustercontrol.ping.ejb.session.MonitorPingControllerUtil;

@javax.jws.WebService
public class MonitorPingEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorPingEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorPingControllerLocal getMonitorPingControllerLocal() throws HinemosUnknownException {
		MonitorPingControllerLocal monitor = null;
		try {
			monitor = MonitorPingControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorPingControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorPingControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * ping監視情報をマネージャに登録します。<BR>
	 * 
	 * @param info 通知情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorDuplicateException 
	 * @throws HinemosUnknownException 
	 * @see  com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean addPingMonitor(MonitorInfo info) throws MonitorDuplicateException, HinemosUnknownException {
		MonitorPingControllerLocal monitor = getMonitorPingControllerLocal();
		return monitor.addPing(info);
	}
	
	/**
	 * マネージャのping監視情報を更新します。<BR>
	 * 
	 * @param info 通知情報
	 * @return 変更に成功した場合、true
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * @see  com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean modifyPingMonitor(MonitorInfo info) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorPingControllerLocal monitor = getMonitorPingControllerLocal();
		return monitor.modifyPing(info);
	}
	
	/**
	 * ping監視情報をマネージャから削除します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public boolean deletePingMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorPingControllerLocal monitor = getMonitorPingControllerLocal();
		return monitor.deletePing(monitorId);
	}
	
	/**
	 * ping監視情報を取得します。<BR>
	 * 
	 * 引数のmonitorIdに対応するPING監視設定情報を取得します。
	 * 
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param monitorId 監視項目ID
	 * @return ping監視情報
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException
	 * @see  com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public MonitorInfo getPingMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorPingControllerLocal monitor = getMonitorPingControllerLocal();
		return monitor.getPing(monitorId);
	}

	/**
	 * ping監視一覧リストを取得します。<BR>
	 * 
	 * @return MonitorInfoの配列
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public ArrayList<MonitorInfo> getPingList() throws MonitorNotFoundException, HinemosUnknownException {
		MonitorPingControllerLocal monitor = getMonitorPingControllerLocal();
		return monitor.getPingList();
	}
	
}
