/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/

package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfControllerLocal;
import com.clustercontrol.performance.monitor.ejb.session.MonitorPerfControllerUtil;
import com.clustercontrol.monitor.run.bean.MonitorInfo;

@javax.jws.WebService
public class MonitorPerfEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorPerfEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorPerfControllerLocal getMonitorPerfControllerLocal() throws HinemosUnknownException {
		MonitorPerfControllerLocal monitor = null;
		try {
			monitor = MonitorPerfControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorPerfControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorPerfControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * リソース監視情報を登録します。<BR>
	 * 
	 * @param info 通知情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorDuplicateException 
	 * @throws HinemosUnknownException 
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean addPerfMonitor(MonitorInfo info) throws MonitorDuplicateException, HinemosUnknownException {
		MonitorPerfControllerLocal monitor = getMonitorPerfControllerLocal();
		return monitor.addPerformance(info);
	}
	
	/**
	 * リソース監視情報を更新します。<BR>
	 * 
	 * @param info 通知情報
	 * @return 変更に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean modifyPerfMonitor(MonitorInfo info) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorPerfControllerLocal monitor = getMonitorPerfControllerLocal();
		return monitor.modifyPerformance(info);
	}
	
	/**
	 * リソース監視情報を削除します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public boolean deletePerfMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorPerfControllerLocal monitor = getMonitorPerfControllerLocal();
		return monitor.deletePerformance(monitorId);
	}
	
	/**
	 * リソース監視情報を取得します。<BR>
	 * 
	 * @param monitorId 状態監視ID
	 * @return Hinemos Perf監視情報
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException 
	 */
	public MonitorInfo getPerfMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorPerfControllerLocal monitor = getMonitorPerfControllerLocal();
		return monitor.getPerformance(monitorId);
	}

	/**
	 * リソース監視一覧リストを返します。
	 * 
	 * @return MonitorInfoの配列
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public ArrayList<MonitorInfo> getPerfList() throws MonitorNotFoundException, HinemosUnknownException {
		MonitorPerfControllerLocal monitor = getMonitorPerfControllerLocal();
		return monitor.getPerformanceList();
	}
	
}
