/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/
package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.http.ejb.session.MonitorHttpControllerLocal;
import com.clustercontrol.http.ejb.session.MonitorHttpControllerUtil;
import com.clustercontrol.monitor.run.bean.MonitorInfo;

@javax.jws.WebService
public class MonitorHttpEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorHttpEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorHttpControllerLocal getMonitorHttpControllerLocal() throws HinemosUnknownException {
		MonitorHttpControllerLocal monitor = null;
		try {
			monitor = MonitorHttpControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorHttpControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorHttpControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * HTTP監視情報をマネージャに登録します。<BR>
	 * 
	 * @param info 監視情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorDuplicateException 
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean addHttpMonitor(MonitorInfo info) throws MonitorDuplicateException, HinemosUnknownException {
		MonitorHttpControllerLocal monitor = getMonitorHttpControllerLocal();
		return monitor.addHttp(info);
	}
	
	/**
	 * HTTP監視情報をマネージャ上で更新します。<BR>
	 * 
	 * @param info 監視情報
	 * @return 変更に成功した場合、true
	 * @throws HinemosUnknownException 
	 * @throws MonitorNotFoundException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean modifyHttpMonitor(MonitorInfo info) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorHttpControllerLocal monitor = getMonitorHttpControllerLocal();
		return monitor.modifyHttp(info);
	}
	
	/**
	 * HTTP監視情報をマネージャから削除します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws HinemosUnknownException 
	 * @throws MonitorNotFoundException 
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean deleteHttpMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorHttpControllerLocal monitor = getMonitorHttpControllerLocal();
		return monitor.deleteHttp(monitorId);
	}
	
	/**
	 * HTTP監視情報を取得します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @param monitorType 監視判定タイプ
	 * @return HTTP監視情報
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public MonitorInfo getHttpMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorHttpControllerLocal monitor = getMonitorHttpControllerLocal();
		return monitor.getHttpInfo(monitorId);
	}
	
	/**
	 * HTTP監視一覧リストを取得します。<BR>
	 * 
	 * @return MonitorInfoの配列
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException
	 */
	public ArrayList<MonitorInfo> getHttpList() throws MonitorNotFoundException, HinemosUnknownException {
		MonitorHttpControllerLocal monitor = getMonitorHttpControllerLocal();
		return monitor.getHttpList();
	}
}
