/*
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
*/

package com.clustercontrol.ws.endpoint;

import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.MonitorDuplicateException;
import com.clustercontrol.MonitorNotFoundException;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentControllerLocal;
import com.clustercontrol.hinemosagent.ejb.session.MonitorAgentControllerUtil;
import com.clustercontrol.monitor.run.bean.MonitorInfo;

@javax.jws.WebService
public class MonitorAgentEndpoint {
	protected static Log m_log = LogFactory.getLog( MonitorAgentEndpoint.class );
	
	public String echo(String str) {
		return str + ", " + str;
	}
	
	private MonitorAgentControllerLocal getMonitorAgentControllerLocal() throws HinemosUnknownException {
		MonitorAgentControllerLocal monitor = null;
		try {
			monitor = MonitorAgentControllerUtil.getLocalHome().create();
		} catch (CreateException e) {
			m_log.error("getMonitorAgentControllerLocal CreateException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		} catch (NamingException e) {
			m_log.error("getMonitorAgentControllerLocal NamingException : " + e,e);
			throw new HinemosUnknownException(e.getMessage(), e);
		}
		return monitor;
	}
	
	/**
	 * Hinemos Agent監視情報を登録します。<BR>
	 * 
	 * @param info 通知情報
	 * @return 登録に成功した場合、true
	 * @throws MonitorDuplicateException 
	 * @throws HinemosUnknownException 
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean addAgentMonitor(MonitorInfo info) throws MonitorDuplicateException, HinemosUnknownException {
		MonitorAgentControllerLocal monitor = getMonitorAgentControllerLocal();
		return monitor.addAgent(info);
	}
	
	/**
	 * Hinemos Agent監視情報を更新します。<BR>
	 * 
	 * @param info 通知情報
	 * @return 変更に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException
	 * @see com.clustercontrol.monitor.run.bean.MonitorInfo
	 */
	public boolean modifyAgentMonitor(MonitorInfo info) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorAgentControllerLocal monitor = getMonitorAgentControllerLocal();
		return monitor.modifyAgent(info);
	}
	
	/**
	 * Hinemos Agent監視情報を削除します。<BR>
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public boolean deleteAgentMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorAgentControllerLocal monitor = getMonitorAgentControllerLocal();
		return monitor.deleteAgent(monitorId);
	}
	
	/**
	 * Hinemos Agent監視情報を取得します。<BR>
	 * 
	 * @param monitorId 状態監視ID
	 * @return Hinemos Agent監視情報
	 * @throws MonitorNotFoundException 
	 * @throws HinemosUnknownException 
	 */
	public MonitorInfo getAgentMonitor(String monitorId) throws MonitorNotFoundException, HinemosUnknownException {
		MonitorAgentControllerLocal monitor = getMonitorAgentControllerLocal();
		return monitor.getAgentInfo(monitorId);
	}

	/**
	 * Hinemos Agent監視一覧リストを返します。
	 * 
	 * @return MonitorInfoの配列
	 * @throws MonitorNotFoundException
	 * @throws HinemosUnknownException 
	 */
	public ArrayList<MonitorInfo> getAgentList() throws MonitorNotFoundException, HinemosUnknownException {
		MonitorAgentControllerLocal monitor = getMonitorAgentControllerLocal();
		return monitor.getAgentList();
	}
	
}
