/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.port.ejb.entity;

import javax.ejb.EntityBean;

/**
 * @ejb.bean name="MonitorProtocolMaster"
 *           jndi-name="MonitorProtocolMaster"
 *           type="CMP"
 *           schema="MonitorProtocolMaster" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="serviceId"
 *           view-type="local" 
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *  
  * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_protocol_mst"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
*  
 *  @jboss.read-only
 *     read-only="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_protocol_mst"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorProtocolMaster as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="java.lang.String"
 *   
 */
public abstract class MonitorProtocolMasterBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public java.lang.String ejbCreate(
			String serviceId,       //監視対象サービスを表すID
			String serviceName,     //監視対象サービス名
			String description,     //説明
			Integer defaultPortNo,  //ポート番号
			String className        //各サービスの監視を実装したクラス名
			) throws javax.ejb.CreateException {

		this.setServiceId(serviceId);
		this.setServiceName(serviceName);
		this.setDescription(description);
		this.setDefaultPortNo(defaultPortNo);
		this.setClassName(className);
		return null;
	}

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="class_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the className.
	 */
	public abstract String getClassName();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The className to set.
	 */
	public abstract void setClassName(String className);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="default_port_number"
	 *     jdbc-type="INTEGER"
	 *     sql-type="INTEGER"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the defaultPortNo.
	 */
	public abstract Integer getDefaultPortNo();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The defaultPortNo to set.
	 */
	public abstract void setDefaultPortNo(Integer defaultPortNo);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false" 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the description.
	 */
	public abstract String getDescription();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The description to set.
	 */
	public abstract void setDescription(String description);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="service_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the serviceId.
	 */
	public abstract String getServiceId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The serviceId to set.
	 */
	public abstract void setServiceId(String serviceId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="service_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the serviceName.
	 */
	public abstract String getServiceName();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The serviceName to set.
	 */
	public abstract void setServiceName(String serviceName);

}
