/*
 
 Copyright (C) 2009 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知イベント情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyTypeMst"
 *     jndi-name="NotifyTypeMst"
 *     type="CMP"
 *     view-type = "local"
 *     primkey-field="notifyType"
 *     schema="NotifyTypeMst"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    	name="Hinemos Config CMP 2.x EntityBean"
 *    
 * @jboss.persistence
 *     datasource="java:/HinemosDS"
 *     datasource-mapping="PostgreSQL 8.0"
 *     table-name="public.cc_notify_type_mst"
 *     create-table="false"
 *     remove-table="false"
 *     alter-table="false"
 *           
 * @jboss.read-only
 * 	   read-only="true"
 *            
 * @ejb.persistence 
 *     table-name="cc_notify_type_mst"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyTypeMst as a"  
 *     signature="java.util.Collection findAll()"
 *
 * @ejb.permission
 *     unchecked="true"
 * 
 * @ejb.data-object extends="com.clustercontrol.notify.bean.NotifyTypeMstInfo"
 *
 * @ejb.pk class="java.lang.Integer"
 */
public abstract class NotifyTypeMstBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知種別マスタを生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param notifyType 通知種別
	 * @param notifyNameKey 通知の表示名をメッセージプロパティから取得する際に使用するキー
	 * @param queueName キュー名
	 * @param actionClassName 通知処理を実行するクラス名
	 * @param dialogClassName クライアント処理で使用するクラス
	 * @param queueType キューの種別
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 */
	public Integer ejbCreate(
			Integer notifyType,
			String notifyNameKey,
			String queueName,
			int useJms,
			int useJta,
			String actionClassName,
			String dialogClassName) throws javax.ejb.CreateException {
		
		setNotifyType(notifyType);
		setNotifyNameKey(notifyNameKey);
		setQueueName(queueName);
		setUseJms(useJms);
		setUseJｔa(useJta);
		setActionClassName(actionClassName);
		setDialogClassName(dialogClassName);
		return notifyType;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	
	/**
	 * 通知種別を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the notify_type.
	 */
	public abstract Integer getNotifyType();

	/**
	 * 通知種別を設定します。
	 * 
	 * @param notifyType The notify_type to set.
	 */
	public abstract void setNotifyType(Integer notifyType);
	
	/**
	 * 通知の表示名をメッセージプロパティから取得する際に使用するキーを取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_name_key"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the notify_name_key.
	 */
	public abstract String getNotifyNameKey();

	/**
	 * 通知の表示名をメッセージプロパティから取得する際に使用するキーを設定します。
	 * 
	 * @param notifyNameKey The notify_name_key to set.
	 */
	public abstract void setNotifyNameKey(String notifyNameKey);
	
	/**
	 * 通知処理の際に使用するキュー名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="queue_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the queue_name.
	 */
	public abstract String getQueueName();

	/**
	 * キュー名を設定します。
	 * 
	 * @param queueName The queue_name to set.
	 */
	public abstract void setQueueName(String queueName);
	
	/**
	 * 通知処理を実行するクラス名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="action_class_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the action_class_name.
	 */
	public abstract String getActionClassName();

	/**
	 * 通知処理を実行するクラス名を設定します。
	 * 
	 * @param actionClassName The action_class_name to set.
	 */
	public abstract void setActionClassName(String actionClassName);
	
	/**
	 * クライアント処理で使用するクラス名を取得します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="dialog_class_name"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the dialog_class_name.
	 */
	public abstract String getDialogClassName();

	/**
	 * クライアント処理で使用するクラスを設定します。
	 * 
	 * @param dialogClassName The dialog_class_name to set.
	 */
	public abstract void setDialogClassName(String dialogClassName);
	
	/**
	 * メッセージ処理にJMSを利用するか否かのフラグを取得します。
	 * 0:使用しない 1:使用する
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="use_jms"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the use_jms.
	 */
	public abstract int getUseJms();

	/**
	 * メッセージ処理にJMSを利用するか否かのフラグを設定します。
	 * 0:使用しない 1:使用する
	 * 
	 * @param useJms The use_jms to set.
	 */
	public abstract void setUseJms(int useJms);
	
	/**
	 * メッセージ処理にJMSを利用しない場合（useJms=0）の場合、
	 * トランザクション管理にJTAを利用するか否かのフラグを取得します。
	 * 0:使用しない 1:使用する
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="use_jta"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns the use_jta.
	 */
	public abstract int getUseJｔa();

	/**
	 * メッセージ処理にJMSを利用しない場合（useJms=0）の場合、
	 * トランザクション管理にJTAを利用するか否かのフラグを設定します。
	 * 0:使用しない 1:使用する
	 * 
	 * @param useJｔa The use_jta to set.
	 */
	public abstract void setUseJｔa(int useJｔa);
	
	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（NotifyInfoData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns Dataオブジェクト（NotifyInfoData）
	 */
	public abstract NotifyTypeMstData getData();
}
