/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知ログエスカレート情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyLogEscalateInfo"
 *     jndi-name="NotifyLogEscalateInfo"
 *     type="CMP"
 *     view-type = "local"
 *     schema="NotifyLogEscalateInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *    
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_notify_log_escalate_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_log_escalate_info"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyLogEscalateInfo as a"  
 *     signature="java.util.Collection findAll()"
 *           
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.interface local-extends="javax.ejb.EJBLocalObject, com.clustercontrol.notify.ejb.entity.NotifyDetail"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyLogEscalateInfoPK"
 */
public abstract class NotifyLogEscalateInfoBean implements EntityBean, NotifyDetail {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知ログエスカレート情報を生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param escalateFlg ログエスカレート通知フラグ
	 * @param escalateMessage 転送メッセージ
	 * @param syslogPriority シスログ重要度
	 * @param syslogFacility シスログファシリティ
	 * @param escalateFacilityFlg 転送先ファシリティフラグ
	 * @param escalateFacility 転送先ファシリティ
	 * @param escalatePort	転送先ポート
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 * @see com.clustercontrol.bean.LogEscalateConfirmConstant
	 */
	public NotifyLogEscalateInfoPK ejbCreate(
			String notifyId,
			Integer priority,
			Integer escalateFlg,
			String  escalateMessage,
			Integer syslogPriority,
			Integer syslogFacility,
			Integer	escalateFacilityFlg,
			String  escalateFacility,
			Integer escaletPort
			) throws javax.ejb.CreateException {
		
		setNotifyId(notifyId);
		setPriority(priority);
		setValidFlg(escalateFlg);
		setEscalateMessage(escalateMessage);
		setSyslogPriority(syslogPriority);
		setSyslogFacility(syslogFacility);
		setEscalateFacilityFlg(escalateFacilityFlg);
		setEscalateFacility(escalateFacility);
		setEscalatePort(escaletPort);
		
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * ログエスカレート通知フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="escalate_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return ログエスカレート通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getValidFlg();
	
	/**
	 * ログエスカレート通知フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param logEscalateNormalFlg ログエスカレート通知フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setValidFlg(Integer commandFlg);
	
	/**
	 * 転送メッセージを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="escalate_message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *     
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getEscalateMessage();
	       
	/**
	 * 転送メッセージを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param escalateMessage 転送メッセージ
	 */
	public abstract void setEscalateMessage(String escalateMessage);
	
	
	/**
	 * シスログ重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="syslog_priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @returnシスログ重要度
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getSyslogPriority();
	
	/**
	 * シスログ重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param syslogPriority シスログ重要度
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setSyslogPriority(Integer syslogPriority);
	
	
	/**
	 * シスログファシリティを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="syslog_facility"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @returnシスログファシリティ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getSyslogFacility();
	
	/**
	 * シスログファシリティを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param syslogPriority シスログファシリティ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setSyslogFacility(Integer syslogFacility);
	
	/**
	 * 転送先ファシリティフラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="escalate_facility_flg"
	 *                 escalete_facility_flg  
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 転送先ファシリティフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getEscalateFacilityFlg();
	
	/**
	 * 転送先ファシリティフラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setEscalateFacilityFlg(Integer escalateFacilityFlg);
	
	
	/**
	 *　転送先ファシリティを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="escalate_facility"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 転送先ファシリティ
	 */
	public abstract String getEscalateFacility();
	
	/**
	 * 転送先ファシリティを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param  escalateFacility 転送先ファシリティ
	 */
	public abstract void setEscalateFacility(String escalateFacility);
	/**
	 * 転送先ポートを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="escalate_port"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 転送先ポート
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getEscalatePort();
	
	/**
	 *  転送先ポートを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setEscalatePort(Integer escalatePort);

	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（NotifyLogEscalateInfoData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns Dataオブジェクト（NotifyLogEscalateInfoData）
	 */
	public abstract NotifyLogEscalateInfoData getData();
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyLogEscalateInfo"
	 * role-name="NotifyLogEscalateInfo-NotifyInfo(multi)"
	 * cascade-delete="true"
	 * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * batch-cascade-delete="true"
	 * 
	 * @return 通知情報
	 */
	public abstract NotifyInfoLocal getNotifyInfo();
	
	/**
	 * 通知情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyInfo 通知情報
	 */
	public abstract void setNotifyInfo(NotifyInfoLocal notifyInfo);
}
