/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 再通知の抑制のための通知実行履歴を保持するCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyHistory"
 *     jndi-name="NotifyHistory"
 *     type="CMP"
 *     view-type = "local"
 *     schema="NotifyHistory"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *         
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *    
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_notify_history"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *           
 * @ejb.persistence 
 *     table-name="cc_notify_history"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyHistory as a"  
 *     signature="java.util.Collection findAll()"
 * 
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyHistory as a WHERE a.monitorId = ?1"
 *     signature="java.util.Collection findByMonitorId(java.lang.String monitorId)"
 * 
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyHistory as a WHERE a.pluginId = ?1 and a.monitorId = ?2"
 *     signature="java.util.Collection findByPluginIdAndMonitorId(java.lang.String pluginId, java.lang.String monitorId)"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyHistoryPK"
 */
public abstract class NotifyHistoryBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 再通知の抑制のための通知実行履歴を保持するCMPを生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param facilityId ファシリティID
	 * @param pluginId プラグインID
	 * @param monitorId 監視項目ID
	 * @param notifyId 通知ID
	 * @param lastNotify 最終通知日時
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 */
	public java.lang.String ejbCreate(
			String facilityId,
			String pluginId,
			String monitorId,
			String notifyId,
			Timestamp lastNotify
			) throws javax.ejb.CreateException {
		setFacilityId(facilityId);
		setPluginId(pluginId);
		setMonitorId(monitorId);
		setNotifyId(notifyId);
		setLastNotify(lastNotify);
		return null;
	}

	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * ファシリティIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public abstract String getFacilityId();
	
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId ファシリティID
	 */
	public abstract void setFacilityId(String facilityId);
	
	/**
	 * プラグインIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="plugin_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return プラグインID
	 */
	public abstract String getPluginId();
	
	/**
	 * プラグインIDを設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param pluginId プラグインID
	 */
	public abstract void setPluginId(String pluginId);
	
    /**
     * 監視項目IDを返します。
     *
     * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return monitorId 監視項目ID
	 */
	public abstract String getMonitorId();
	
	
	/**
	 * 監視項目IDを設定します。
	 *
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param monitorId
	 */
	public abstract void setMonitorId(String monitorId);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 *    name="NotifyInfo-NotifyHistory"
	 *    role-name="NotifyHistory-NotifyInfo(multi)"
	 *    cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="notifyId"
	 *    fk-column="notify_id"
	 *    batch-cascade-delete="true"
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 最終通知日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="last_notify"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return 最終通知日時
	 */
	public abstract Timestamp getLastNotify();
	
	/**
	 * 最終通知日時を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param lastNotify 最終通知日時
	 */
	public abstract void setLastNotify(Timestamp lastNotify);
	
	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（NotifyHistoryData）を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns Dataオブジェクト（NotifyHistoryData）
	 */
	public abstract NotifyHistoryData getData();
}
