/*
 
 Copyright (C) 2009 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 通知イベン情報のCMP Entity Beanです。
 * 
 * @ejb.bean name="NotifyCommandInfo"
 *     jndi-name="NotifyCommandInfo"
 *     type="CMP"
 *     view-type = "local"
 *     schema="NotifyCommandInfo"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *       
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *    
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_notify_command_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 * 
 * @ejb.persistence 
 *     table-name="cc_notify_command_info"
 * 
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM NotifyCommandInfo as a"  
 *     signature="java.util.Collection findAll()"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.interface local-extends="javax.ejb.EJBLocalObject, com.clustercontrol.notify.ejb.entity.NotifyDetail"
 *     
 * @ejb.data-object extends="com.clustercontrol.notify.bean.NotifyCommandInfo"
 * 
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyCommandInfoPK"
 */
public abstract class NotifyCommandInfoBean implements EntityBean, NotifyDetail {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知コマンド情報を生成します。
	 *
	 * @ejb.create-method
	 * 
	 * @param notifyId 通知ID
	 * @param priority 重要度
	 * @param commandFlg 実行フラグ
	 * @param command 実行コマンド
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public NotifyCommandInfoPK ejbCreate(NotifyCommandInfoData data) throws javax.ejb.CreateException {
		setNotifyId(data.getNotifyId());
		setPriority(data.getPriority());
		setValidFlg(data.getValidFlg());
		setCommand(data.getCommand());
		setEffectiveUser(data.getEffectiveUser());
		setSetEnvironment(data.getSetEnvironment());
		setTimeout(data.getTimeout());
		return null;
	}
	
	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * 実行フラグを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 実行フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getValidFlg();
	
	/**
	 * 実行フラグを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param commandFlg 実行フラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setValidFlg(Integer commandFlg);
	
	/**
	 * 実行コマンドを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="command"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 実行コマンド
	 */
	public abstract String getCommand();
	
	/**
	 * 実行コマンドを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param command 実行コマンド
	 */
	public abstract void setCommand(String command);
	
	/**
	 * 実効ユーザを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="effective_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 実効ユーザ
	 */
	public abstract String getEffectiveUser();
	
	/**
	 * 実効ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param user 実効ユーザ
	 */
	public abstract void setEffectiveUser(String user);
	
	/**
	 * コマンド実行時に環境変数を読み込むか否かのフラグを取得します。
	 * 具体的にはsuコマンドを実行する際に'-'をつけるか否か
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="set_environment"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 環境変数を読み込むか否かのフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getSetEnvironment();
	
	/**
	 * コマンド実行時に環境変数を読み込むか否かのフラグを設定する。
	 * 具体的にはsuコマンドを実行する際に'-'をつけるか否か
	 * 
	 * @ejb.interface-method
	 * 
	 * @param setEnv 環境変数を読み込むか否かのフラグ
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setSetEnvironment(Integer setEnv);
	
	/**
	 * コマンド実行のタイムアウト値を取得します。
	 * コマンド実行後、この値を超えた場合は強制的に終了されます。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="command_timeout"
	 *     jdbc-type="BIGINT"
	 *     sql-type="bigint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return タイムアウト値（ミリ秒）
	 */
	public abstract Long getTimeout();
	
	/**
	 * コマンド実行のタイムアウト値を設定する。
	 * コマンド実行後、この値を超えた場合は強制的に終了されます。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param setEnv タイムアウト値（ミリ秒）
	 */
	public abstract void setTimeout(Long timeout);
	
	
	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（NotifyCommandInfoData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns Dataオブジェクト（NotifyCommandInfoData）
	 */
	public abstract NotifyCommandInfoData getData();
	
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * 通知情報を返します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @ejb.relation 
	 * name="NotifyInfo-NotifyCommandInfo"
	 * role-name="NotifyCommandInfo-NotifyInfo(multi)"
	 * cascade-delete="true"
	 * 
	 * @jboss.relation
	 * related-pk-field="notifyId"
	 * fk-column="notify_id"
	 * batch-cascade-delete="true"
	 * 
	 * @return 通知情報
	 */
	public abstract NotifyInfoLocal getNotifyInfo();
	
	/**
	 * 通知情報を設定します。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @param notifyInfo 通知情報
	 */
	public abstract void setNotifyInfo(NotifyInfoLocal notifyInfo);
}
