/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 監視結果の重要度ステータスを保持するCMP Entity Beanです。
 * 
 * @ejb.bean name="MonitorStatus"
 *     jndi-name="MonitorStatus"
 *     type="CMP"
 *     view-type = "local"
 *     schema="MonitorStatus"
 *     cmp-version="2.x"
 *     data-source="java:/HinemosDS"
 *         
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 *    
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 *    
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_status"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 *           
 * @ejb.persistence 
 *     table-name="cc_monitor_status"
 *     
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM MonitorStatus as a"  
 *     signature="java.util.Collection findAll()"
 * 
 * @ejb.finder 
 *     query="SELECT OBJECT(a) FROM MonitorStatus as a WHERE a.pluginId = ?1 and a.monitorId = ?2"
 *     signature="java.util.Collection findByPluginIdAndMonitorId(java.lang.String pluginId, java.lang.String monitorId)"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.MonitorStatusPK"
 */
public abstract class MonitorStatusBean implements EntityBean {
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#setEntityContext(javax.ejb.EntityContext)
	 */
	public void setEntityContext(EntityContext ctx) throws EJBException, RemoteException {
	}
	
	/* (非 Javadoc)
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}
	
	/**
	 * 監視結果の重要度ステータスを保持するCMPを生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param facilityId ファシリティID
	 * @param pluginId プラグインID
	 * @param monitorId 監視項目ID
	 * @param priority 重要度
	 * @param lastUpdate 最終重要度更新日時
	 * @param counter 同一重要度カウンタ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public java.lang.String ejbCreate(
			String facilityId,
			String pluginId,
			String monitorId,
			Integer priority,
			Timestamp lastUpdate,
			Long counter
			) throws javax.ejb.CreateException {
		setFacilityId(facilityId);
		setPluginId(pluginId);
		setMonitorId(monitorId);
		setPriority(priority);
		setLastUpdate(lastUpdate);
		setCounter(counter);
//		setUseType(useType);
		
		return null;
	}
	


	public void ejbRemove() throws RemoveException, EJBException, RemoteException {
	}
	
	public void ejbActivate() throws EJBException, RemoteException {
	}
	
	public void ejbPassivate() throws EJBException, RemoteException {
	}
	
	public void ejbLoad() throws EJBException, RemoteException {
	}
	
	public void ejbStore() throws EJBException, RemoteException {
	}
	
	/**
	 * ファシリティIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public abstract String getFacilityId();
	
	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId ファシリティID
	 */
	public abstract void setFacilityId(String facilityId);
	
	/**
	 * プラグインIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="plugin_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return プラグインID
	 */
	public abstract String getPluginId();
	
	/**
	 * プラグインIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param pluginId プラグインID
	 */
	public abstract void setPluginId(String pluginId);
	
    /**
     * 監視項目IDを返します。
     *
     * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method 
     * 
     * @return monitorId 監視項目ID
     */
	public abstract String getMonitorId();
	
	
	/**
	 * 監視項目IDを設定します。
	 *
	 * @ejb.interface-method
	 * 
	 * @param monitorId
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 */
	public abstract Integer getPriority();
	
	/**
	 * 重要度）を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param initialCount 重要度
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * 最終重要度更新日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="last_update"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 最終重要度更新日時
	 */
	public abstract Timestamp getLastUpdate();
	
	/**
	 * 最終重要度更新日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param lastUpdate 最終重要度更新日時
	 */
	public abstract void setLastUpdate(Timestamp lastUpdate);
	

	
	/**
	 * 同一重要度カウンタを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="counter"
	 *     jdbc-type="BIGINT"
	 *     sql-type="bigint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return vaildFlg 同一重要度カウンタ
	 */
	public abstract Long getCounter();

	/**
     * 同一重要度カウンタを設定します。
     * 
     * @ejb.interface-method 
	 * @param vaildFlg 同一重要度カウンタ
	 */
	public abstract void setCounter(Long counter);
	
	/**
	 * このCMPのデータをフィールドとして持つDataオブジェクト（MonitorStatusData）を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @jboss.method-attributes read-only="true"
	 * 
	 * @return Returns Dataオブジェクト（MonitorStatusData）
	 */
	public abstract MonitorStatusData getData();
}
