package com.clustercontrol.monitor.run.util;

import java.util.concurrent.Callable;

import com.clustercontrol.monitor.run.bean.MonitorRunResultInfo;
import com.clustercontrol.monitor.run.factory.RunMonitor;

/**
 * 
 * 各監視を実行するクラスです。
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class CallableTask implements Callable<MonitorRunResultInfo>{

	private RunMonitor m_runMonitor;
	private String m_facilityId;
	
	/**
	 * コンストラクタ
	 * @param facilityId
	 */
	public CallableTask(RunMonitor monitor, String facilityId) {
		m_runMonitor = monitor;
		m_facilityId = facilityId;
	}
	
	/**
	 * 各監視を実行します。
	 * 
	 * @see #setMonitorInfo(String, String)
	 */
	public MonitorRunResultInfo call() throws Exception {
		
		// 結果を格納
		MonitorRunResultInfo info = new MonitorRunResultInfo();
				
		// 各監視処理を実行し、実行の可否を格納
		Boolean ret = m_runMonitor.collect(m_facilityId);
		
		// 監視値より判定結果を取得
		Integer checkResult = m_runMonitor.getCheckResult(ret);
			
		info.setRet(ret);
		info.setCheakResult(checkResult);
		info.setMessage(m_runMonitor.getMessage(checkResult));
		info.setMessageId(m_runMonitor.getMessageId(checkResult));
		info.setMessageOrg(m_runMonitor.getMessageOrg(checkResult));
//		info.setJobRunInfo(m_runMonitor.getJobRunInfo(checkResult));
		info.setPriority(m_runMonitor.getPriority(checkResult));
		info.setNodeDate(m_runMonitor.getNodeDate());
		
		// 通知グループIDをセットする
		// SNMP文字列監視のマルチスレッド化対応用の実装
		info.setNotifyGroupId(m_runMonitor.getNotifyGroupId());
		
		return info;
	}

}
