/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.ejb.entity;

import javax.ejb.EntityBean;

/**
 * 数値監視判定情報のCMP Entity Bean<BR>
 * 
 * @ejb.bean name="MonitorNumericValueInfo"
 *    jndi-name="MonitorNumericValueInfo"
 *    schema="MonitorNumericValueInfo" 
 *    type="CMP"
 *    view-type="local" 
 *    cmp-version="2.x"
 *    data-source="java:/HinemosDS"
 * 
 * @ejb.persistence 
 *   table-name="public.cc_monitor_numeric_value_info" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorNumericValueInfo as a"  
 *    signature="java.util.Collection findAll()"
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorNumericValueInfo as a WHERE a.monitorTypeId = ?1 AND a.monitorId = ?2"  
 *    signature="java.util.Collection findByMonitorTypeIdAndMonitorId(java.lang.String monitorTypeId, java.lang.String monitorId)"
 * 
 * @ejb.pk
 *    class="com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoPK"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/HinemosDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_monitor_numeric_value_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 */
public abstract class MonitorNumericValueInfoBean implements EntityBean {
	
	/**
	 * 数値監視判定情報を生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param monitorTypeId 監視対象ID
	 * @param monitorId 監視項目ID
	 * @param priority 重要度
	 * @param thresholdUpperLimit 閾値上限
	 * @param thresholdLowerLimit 閾値下限
	 * @param messageId メッセージID
	 * @param message メッセージ
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public MonitorNumericValueInfoPK ejbCreate(
			String monitorTypeId, 
			String monitorId, 
			Integer priority, 
			Double thresholdUpperLimit, 
			Double thresholdLowerLimit, 
			String messageId, 
			String message
			) throws javax.ejb.CreateException {

		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setPriority(priority);
		this.setThresholdUpperLimit(thresholdUpperLimit);
		this.setThresholdLowerLimit(thresholdLowerLimit);
		this.setMessageId(messageId);
		this.setMessage(message);
		
		return null;
	}

	/**
	 * メッセージを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return メッセージ
	 */
	public abstract String getMessage();

	/**
	 * メッセージを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param message メッセージ
	 */
	public abstract void setMessage(String message);

	/**
	 * メッセージIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return メッセージID
	 */
	public abstract String getMessageId();

	/**
	 * メッセージIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param messageId メッセージID
	 */
	public abstract void setMessageId(String messageId);

	/**
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract String getMonitorId();

	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * 監視対象IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視対象ID
	 */
	public abstract String getMonitorTypeId();

	/**
	 * 監視対象IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId 監視対象ID
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();

	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * 閾値下限を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="threshold_lower_limit"
	 *     jdbc-type="DOUBLE"
	 *     sql-type="double precision"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 閾値下限
	 */
	public abstract Double getThresholdLowerLimit();

	/**
	 * 閾値下限を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param thresholdLowerLimit 閾値下限
	 */
	public abstract void setThresholdLowerLimit(Double thresholdLowerLimit);

	/**
	 * 閾値上限を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="threshold_upper_limit"
	 *     jdbc-type="DOUBLE"
	 *     sql-type="double precision"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 閾値上限
	 */
	public abstract Double getThresholdUpperLimit();

	/**
	 * 閾値上限を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param thresholdUpperLimit 閾値上限
	 */
	public abstract void setThresholdUpperLimit(Double thresholdUpperLimit);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
    /**
     * 監視情報を返します。
     * 
     * @ejb.interface-method
     *    view-type="local"
     * 
     * @ejb.relation
     *    name="MonitorInfo-MonitorNumericValueInfo"
     *    role-name="MonitorNumericValueInfo-NotifyInfo(multi)"
     *    cascade-delete="true"
     * 
     * @jboss.relation
	 *    related-pk-field="monitorTypeId"
	 *    fk-column="monitor_type_id"
	 *    batch-cascade-delete="true"
	 * 
	 * @jboss.relation
	 *    related-pk-field="monitorId"
	 *    fk-column="monitor_id"
	 *    batch-cascade-delete="true"
	 * 
	 * @return 監視情報
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
     */
    public abstract MonitorInfoLocal getMonitorInfo();
    
    /**
     * 監視情報を設定します。
     * 
     * @ejb.interface-method
     *    view-type="local"
     * 
     * @param monitorInfo 監視情報
     * 
     * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
     */
    public abstract void setMonitorInfo(MonitorInfoLocal monitorInfo);
}
