/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.JobMasterNotFoundException;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.jobmanagement.bean.QuartzConstant;
import com.clustercontrol.jobmanagement.bean.JobSchedule;
import com.clustercontrol.jobmanagement.util.ManagementUserUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.quartzmanager.util.QuartzUtil;

/**
 * スケジュール一覧情報を検索するクラスです。
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectSchedule {
    protected static Log m_log = LogFactory.getLog( SelectSchedule.class );
    
	/**
	 * スケジュール一覧情報を取得します。
	 * <p>
	 * <ol>
	 * <li>Quartzからスケジュール情報を取得します。</li>
	 * <li>取得したスケジュール情報の数、以下の処理を行います。</li>
	 *  <ol>
	 *  <li>セッションからセッションジョブを取得します。</li>
	 *  <li>セッションジョブからジョブ情報を取得します。</li>
	 *  <li>1スケジュール情報をテーブルのカラム順（{@link com.clustercontrol.jobmanagement.bean.ScheduleTableDefine}）に、リスト（{@link ArrayList}）にセットします。</li>
	 *   <dl>
	 *   <dt>スケジュール情報一覧（Objectの2次元配列）</dt>
	 *   <dd>{ スケジュール情報1 {カラム1の値, カラム2の値, … }, スケジュール情報2{カラム1の値, カラム2の値, …}, … }</dd>
	 *   </dl>
	 *  </ol>
	 * </ol>
	 * 
     * @return スケジュール一覧情報
     * @throws NamingException
     * @throws SchedulerException
	 * @throws JobMasterNotFoundException 
     */
	public ArrayList<JobSchedule> getScheduleList(String userId) throws NamingException, SchedulerException, JobMasterNotFoundException {
        m_log.debug("getScheduleList()");
        
        ArrayList<JobSchedule> list = new ArrayList<JobSchedule>();
        
        //QuartzのSchedulerをルックアップ
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //ジョブ名リスト取得
        String[] jobs = null;
		try {
			jobs = manager.getJobs(QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
			//TODO RemoteException 未実装
		}
        for(int i = 0; i < jobs.length; i++){
            //ジョブ(JobDetail)取得
            JobDetail job = null;
			try {
				job = manager.getJobDetail(jobs[i], QuartzConstant.GROUP_NAME);
			} catch (RemoteException e) {
				//TODO RemoteException 未実装
			}
			
			Object[] jdArgs = (Object[])job.getJobDataMap().get(EJBInvokerJob.EJB_ARGS_KEY);
			String jobunitId = ((String)jdArgs[QuartzConstant.INDEX_JOBUNIT_ID]);
			
			//参照可能なジョブユニットIDを持つスケジュールを取得する
			if (ManagementUserUtil.isReferable(jobunitId, userId)) {
				
				// ArrayList<Object> info = new ArrayList<Object>();
				JobSchedule info = new JobSchedule();
				//スケジュールIDを取得
				info.setId(job.getName());
				//スケジュール名を取得
				info.setName(job.getDescription());
				//ジョブIDを取得
				info.setJobId((String)jdArgs[QuartzConstant.INDEX_JOB_ID]);
				//ジョブ名を取得
				String jobName = (String)job.getJobDataMap().get(QuartzConstant.JOB_NAME_KEY);
				info.setJobName(jobName);
				//ジョブユニットIDを取得
				info.setJobunitId(jobunitId);
				//カレンダIDを取得
				if(jdArgs.length > 1) {
					info.setCalendarId((String)jdArgs[QuartzConstant.INDEX_CALENDAR_ID]);
				} else {
					info.setCalendarId("");
				}
				//スケジュール定義を取得
				Schedule schedule = (Schedule)job.getJobDataMap().get(QuartzConstant.SCHEDULE_KEY);
				info.setSchedule(schedule);
				//有効/無効を取得
				Integer valid = (Integer)job.getJobDataMap().get(QuartzConstant.VALID_KEY);
				info.setValid(valid);
				//登録者を取得
				String createUser = (String)job.getJobDataMap().get(QuartzConstant.CREATE_USER_KEY);
				info.setCreateUser(createUser);
				//登録日時を取得
				Date createDate = (Date)job.getJobDataMap().get(QuartzConstant.CREATE_DATE_KEY);
				info.setCreateTime(createDate);
				//更新者を取得
				String upadteUser = (String)job.getJobDataMap().get(QuartzConstant.UPDATE_USER_KEY);
				info.setUpdateUser(upadteUser);
				//更新日時を取得
				Date upadteDate = (Date)job.getJobDataMap().get(QuartzConstant.UPDATE_DATE_KEY);
				info.setUpdateTime(upadteDate);
				list.add(info);
			}
		}
		return list;
	}


}
