/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.mdb;

import java.util.ArrayList;

import javax.jms.ObjectMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.JobInfoNotFoundException;
import com.clustercontrol.jobmanagement.bean.CommandTypeConstant;
import com.clustercontrol.jobmanagement.bean.TopicConstant;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementUtil;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.jobmanagement.util.SendTopic;
import com.clustercontrol.util.Dummy;

/**
 * ジョブエージェントからの実行結果情報を受信する Message-Driven Bean クラス<BR>
 * <p>実行結果情報を受信し、受信した実行結果情報に基づいて<BR>
 * ノード終了処理を行います。
 *
 * @ejb.bean name="JobResponseBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrolJobManagementStatus"
 * 
 * @jboss.depends name="user:service=HinemosService,name=HinemosService"
 * 
 * @ejb.transaction
 *     type="Required"
 * 
 * @jboss.container-configuration
 *     name="Singleton Message Driven Bean"
 *     
 * @jonas.message-driven-destination 
 *     jndi-name="queue/clustercontrolJobManagementStatus"
 * @jboss.destination-jndi-name 
 *     name="queue/clustercontrolJobManagementStatus"
 *

 * @generated
 */
public class JobResponseBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( JobResponseBean.class );
    
	/** コンテキスト情報 */
    private javax.ejb.MessageDrivenContext messageContext = null;

	/**
	 * コンテキスト情報を設定します。<BR>
	 * Message-Driven Bean がインスタンスプールに格納される際に行う処理を実装します。<BR>
	 * @see javax.ejb.MessageDrivenBean#setMessageDrivenContext(javax.ejb.MessageDrivenContext)
	 */
    public void setMessageDrivenContext(
            javax.ejb.MessageDrivenContext messageContext)
            throws javax.ejb.EJBException {
        this.messageContext = messageContext;
    }

	/** 
	 * 未処理。Message-Driven Bean が生成される際に行う処理を実装します。<BR>
	 * @ejb.create-method 
	 */
    public void ejbCreate() {
        
    }

	/** 
	 * 未処理。Message-Driven Bean が削除される際に行う処理を実装します。<BR>
	 * @see javax.ejb.MessageDrivenBean#ejbRemove()
	 */
    public void ejbRemove() {
        messageContext = null;
    }

    /**
     * 引数で指定された受信メッセージ(実行終了情報)を元に、ノード終了処理を行います。<BR>
	 * 実行終了情報に基づいたノード終了処理にて、FinderExceptionが発生した場合、<BR>
	 * ジョブエージェントに実行指示情報(実行履歴削除)を送信する。
	 * 
     * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
     * 
     * @see com.clustercontrol.jobmanagement.message.RunResultInfo
     * @see com.clustercontrol.jobmanagement.message.RunInstructionInfo
     * @see com.clustercontrol.jobmanagement.ejb.session.JobRunManagementBean#endNode(RunResultInfo)
     * @see com.clustercontrol.jobmanagement.util.SendTopic#put(RunInstructionInfo)
     */
    public void onMessage(javax.jms.Message message) {
        m_log.debug("onMessage()");
        try {
            if(message instanceof ObjectMessage){
                ObjectMessage objectMessage = (ObjectMessage)message;
                
                Object obj = objectMessage.getObject();
                	
                if(obj instanceof RunResultInfo){

                    RunResultInfo info = (RunResultInfo)obj;

                    m_log.debug("onMessage() receive: SessionId = " + info.getSessionId() + ", JobId = " + info.getJobId() + ", FacilityId = " + info.getFacilityId() + ", status = " + info.getStatus() + ", CommandType = " + info.getCommandType());

    	            JobRunManagementLocal JobRunManagement = 
    	                JobRunManagementUtil.getLocalHome().create();
    	            
                    try {
                        JobRunManagement.endNode(info);
            		} catch (JobInfoNotFoundException e) {
            			m_log.debug("onMessage() : jobInfo not found : drop this message." + 
            					" sessionId=" + info.getSessionId() + 
            					", jobId=" + info.getJobId() + 
            					", facilityId=" + info.getFacilityId());
            			
            			if(info.getCommandType() == CommandTypeConstant.NORMAL || 
            					info.getCommandType() == CommandTypeConstant.STOP){
            				//履歴削除情報を作成
            				RunInstructionInfo instructionInfo = new RunInstructionInfo();
            				instructionInfo.setSessionId(info.getSessionId());
            				instructionInfo.setJobId(info.getJobId());
            				instructionInfo.setFacilityId(info.getFacilityId());
            				instructionInfo.setCommand("");
            				if(info.getCommandType() == CommandTypeConstant.NORMAL)
            					instructionInfo.setCommandType(CommandTypeConstant.DELETE_NORMAL_HISTORY);
            				else if(info.getCommandType() == CommandTypeConstant.STOP)
            					instructionInfo.setCommandType(CommandTypeConstant.DELETE_STOP_HISTORY);
            				
            				try {
            					//Topicに送信
            					SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
            					send.put(instructionInfo);
            				} catch (Exception e1) {
            					m_log.debug("onMessage() : RunInstructionInfo transmission error : " + e.getMessage());
            				}
            			}
                    } catch (Exception e) {
                    	m_log.debug("onMessage() : endNode() : " + e.getMessage());
                    }
                }
                else if(obj instanceof Dummy){
					// Dummyデータによる疎通確認時
					m_log.debug("onMessage(): ObjectMessage is Dummy.");
					sendDummyTopic((Dummy)obj);
                }
                else{
                	m_log.error("onMessage(): ObjectMessage is not an expected instance. " + obj.toString());
                }
	        }
        } catch (Exception e) {
        	m_log.debug("onMessage() : " + e.getMessage());
        }
    }
    
	/**
	 * Dummyの通信発生のためのTOPIC送信を行う
	 * 
	 * @param info
	 */
	public void sendDummyTopic(Dummy info){
		m_log.debug("sendDummyTopic(): start.");
		
		ArrayList<String> facilityIdList = info.getFacilityIdList();
		if(facilityIdList != null && facilityIdList.size() > 0){
			SendTopic send = null;

			// 対象のファシリティIDを1つだけ選択する
			String facilityId = facilityIdList.get(0);
			
			// ログ転送設定更新用トピック送信
			try{
				// Topicに送信
				m_log.debug("sendDummyTopic(): start. " + TopicConstant.TOPIC_NAME_EXECUTE);
				send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(facilityId, info);
			} catch (Exception e) {
				m_log.error("sendDummyTopic()", e);
			} finally{
				if(send != null){
					try {
						send.terminate();
					} catch (Exception e) {
					}
				}
			}
			// リポジトリUPDATE用トピック送信
			try{
				// Topicに送信
				m_log.debug("sendDummyTopic(): start. " + com.clustercontrol.repository.bean.TopicConstant.TOPIC_NAME_EXECUTE);
				send = new SendTopic(com.clustercontrol.repository.bean.TopicConstant.TOPIC_NAME_EXECUTE);
				send.put(facilityId, info);
			} catch (Exception e) {
				m_log.error("sendDummyTopic()", e);
			} finally{
				if(send != null){
					try {
						send.terminate();
					} catch (Exception e) {
					}
				}
			}
		}
	}
}
