/*
 
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;


/**
 * 
 * ジョブユーザリレーションマスタのBMP Entity Bean クラス<BR>
 * 
 * @version 3.2.0
 * @since 3.2.0
 * 
 * @ejb.bean name="JobUserRelationMaster"
 *    jndi-name="JobUserRelationMaster"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobUserRelationMasterDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobUserRelationMasterDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 */
public abstract class JobUserRelationMasterBean implements javax.ejb.EntityBean {

	/** 所属ジョブユニットのジョブID */
	protected String jobunit_id;
	
	/** ジョブID */
	protected String job_id;
	
	/** ユーザID */
	protected String user_id;
	
	/**
	 * @ejb.create-method
	 * 
	 * @param jobunit_id
	 * @param job_id
	 * @param user_id
	 * 
	 * @throws javax.ejb.CreateException
	 * 
	 * @return プライマリキー
	 */
	public JobUserRelationMasterPK ejbCreate(String jobunit_id, String job_id, String user_id) throws javax.ejb.CreateException {
		
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.user_id = user_id;
		
		return null;
	}
	
	/**
	 * 全てのジョブユーザリレーションマスタを検索します。<BR>
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobUserRelationMasterDAOImpl#findAll()
	 */
	public Collection<JobUserRelationMasterPK> ejbFindAll() throws FinderException {
		return null;
	}

	/**
	 * プライマリキーに一致するジョブユーザリレーションマスタを検索します。<BR>
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobUserRelationMasterDAOImpl#findByPrimaryKey(JobUserRelationMasterPK)
	 */
	public JobUserRelationMasterPK ejbFindByPrimaryKey(JobUserRelationMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * ジョブユニットIDに一致するジョブユーザリレーションマスタを検索します。<BR>
	 * 
	 * @param jobunitId 所属ジョブユニットのジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobUserRelationMasterDAOImpl#findJobId(String)
	 */
	public Collection<JobUserRelationMasterPK> ejbFindByJobunitId(String jobunitId) throws FinderException {
		return null;
	}
	
	/**
	 * ユーザIDに一致するジョブユーザリレーションマスタを検索します。<BR>
	 * 
	 * @param user_id ユーザID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobUserRelationMasterDAOImpl#findByUserId(String)
	 */
	public Collection<JobUserRelationMasterPK> ejbFindByUserId(String userId) throws FinderException {
		return null;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public String getJobunit_id() {
		return jobunit_id;
	}
	
	/**
	 * 所属ジョブユニットのジョブIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}
	
	/**
	 * ジョブIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public String getJob_id() {
		return job_id;
	}
	
	/**
	 * ジョブIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id ジョブID
	 */
	public void setJob_id(String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * ユーザIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ユーザID
	 */
	public String getUser_id() {
		return user_id;
	}
	
	/**
	 * ユーザIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param user_id ユーザID
	 */
	public void setUser_id(String user_id) {
		this.user_id = user_id;
	}
	
}
