/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.Collection;
import com.clustercontrol.notify.bean.NotifyRelationInfo;

/**
 * ジョブの通知に関する情報を保持するクラス<BR>
 * 
 * @version 3.0.0
 * @since 1.0.0
 */
public class JobNotificationsInfo implements Serializable, Cloneable{
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 3052367114166008592L;
	
	/** 終了状態 */
	protected int m_type;
	
	/** 重要度 */
	protected int m_priority;
	
	/** 通知グループID */
	protected String m_notifyGroupId;
	
	
	/** 通知ID**/
	protected Collection<NotifyRelationInfo> m_notifyId;

	
	
	/**
	 * コンストラクター
	 */
	public JobNotificationsInfo() {
		super();
		
	}

	/**
	 * 重要度を返す。<BR>
	 * @return 重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public int getPriority() {
		return m_priority;
	}
	
	/**
	 * 重要度を設定する。<BR>
	 * @param priority 重要度
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setPriority(int priority) {
		this.m_priority = priority;
	}
	
	/**
	 * 通知IDを返す。<BR>
	 * @return 通知ID
	 */
	public String getNotifyGroupId() {
		return m_notifyGroupId;
	}
	
	/**
	 * 通知IDを設定する。<BR>
	 * @param notify_id 通知ID
	 */
	public void setNotifyGroupId(String notifyGroupId) {
		this.m_notifyGroupId = notifyGroupId;
	}
	
	/**
	 * 終了状態を返す。<BR>
	 * @return 終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public int getType() {
		return m_type;
	}
	
	/**
	 * 終了状態を設定する。<BR>
	 * @param type 終了状態
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setType(int type) {
		this.m_type = type;
	}
	
	/**
	 * ジョブ通知情報のクローンを作成する。<BR>
	 * @return ジョブ通知情報のクローン
	 * @see java.lang.Object#clone()
	 */
	@Override
	protected Object clone() {
		try {
			JobNotificationsInfo clone = (JobNotificationsInfo)super.clone();
			
			clone.setNotifyGroupId(this.getNotifyGroupId());
			clone.setPriority(this.getPriority());
			clone.setType(this.getType());
			clone.setNotifyId(this.getNotifyId());
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}

	/**
	 * 通知IDを返します。
	 * @return　通知IDのコレクション
	 */
	public Collection<NotifyRelationInfo> getNotifyId() {
		return m_notifyId;
	}

	/**
	 * 通知IDを設定します。
	 * 
	 * @param notifyId
	 */
	public void setNotifyId(Collection<NotifyRelationInfo> notifyId) {
		this.m_notifyId = notifyId;
	}
}