/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

/**
 * ジョブ[ファイル転送]ビューのテーブル定義を定数として定義するクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ForwardFileTableDefine {

	/** 実行状態 */
    public static final int STATUS = 0;
    /** 終了状態 */
	public static final int END_STATUS = 1;
	/** ファイル */
	public static final int FILE_NAME = 2;
	/** 転送ファシリティID */
	public static final int SRC_FACILITY_ID = 3;
	/** 転送ファシリティ名 */
	public static final int SRC_FACILITY_NAME = 4;
	/** 受信ファシリティID */
	public static final int DEST_FACILITY_ID = 5;
	/** 受信ファシリティ名 */
	public static final int DEST_FACILITY_NAME = 6;
	/** 開始・再実行日時 */
	public static final int START_RERUN_TIME = 7;
	/** 終了・中断日時 */
	public static final int END_SUSPEND_TIME = 8;
	
	/** 初期表示時ソートカラム */
	public static final int SORT_COLUMN_INDEX = STATUS;
	/** 初期表示時ソートオーダー (昇順=1, 降順=-1) */
	public static final int SORT_ORDER = 1;
	
}
