#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################
DBHOST=localhost
DBPORT=24001
DBNAME=postgres
DBUSER=hinemos
DBPASSWORD=hinemos

########################################
#  Local Message
########################################

# INFO
MSG_I001="restoring Hinemos RDBMS Server from file (PostgreSQL)..."
MSG_I002="   input file : "
MSG_I003="dropping hinemos database..."
MSG_I101="successful in restoring Hinemos RDBMS Server (PostgreSQL)."

# WARN
MSG_W001="file not found. check file's path and try again."
MSG_W002="restoring database is canceled."
MSG_W003="Your input is invalid. Please input again."

# ERROR
MSG_E001="failed to drop database."
MSG_E002="failed to restore Hinemos RDBMS Server (PostgreSQL)."
MSG_E003="failed to execute pg_dump command."

########################################
# Function
########################################

#
# show usage
#
function usage {
	echo "usage : ${PROG} [-w password] filename"
	echo "options:"
	echo "  -w passwd  set password (for Hinemos RDBM Server)"
}

#
# restore PostgreSQL
#
function restore_postgresql {
	ReadPostgreSQLPasswd
	
	# clear database
	Logging "${MSG_I003}"
	MSG=`${PG_HOME}/bin/psql -h ${DBHOST} -p ${DBPORT} -U ${DBUSER} -d ${DBNAME} -A -t -c "DROP DATABASE hinemos" 2>&1`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		echo ${MSG} | grep "database \"hinemos\" does not exist" > /dev/null
		if [ $? -ne 0 ]
		then
			Logging "${MSG}"
			Logging "${MSG_E001}"
			RET=$((16 + ${RET}))
			return ${RET}
		fi
	fi
	
	# restore database
	Logging "${MSG_I001}"
	Logging "${MSG_I002}${DUMP_FILE}"
	MSG=`${PG_HOME}/bin/psql -h ${DBHOST} -p ${DBPORT} -U ${DBUSER} -d ${DBNAME} -f ${DUMP_FILE} 2>&1`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging $MSG
		Logging "${MSG_E003}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	
	return 0
}

########################################
# SHELL
########################################

# check parameters
for OPT in $@
do
	case $OPT in
		--help)
			usage
			exit 0
			;;
	esac
done

# option check
while getopts w: OPT
do
	case $OPT in
		w)
			PASSWD=$OPTARG
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 1 ]
then
	ExitIllegalArgumentError
fi

DUMP_FILE=$1

if [ ! -e ${DUMP_FILE} ]
then
	Logging "${DUMP_FILE}: ${MSG_W001}"
	exit 5
fi

# check process
CheckJBossProcessStopped
CheckPostgreSQLProcessRunning


# main
restore_postgresql
RET=$?
if [ ${RET} -ne 0 ]
then
	Logging "${MSG_E002}"
	exit ${RET}
fi

########################################
# Termination Processing
########################################

Logging "${MSG_I101}"
exit ${RET}
