#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

export JAVA_OPTS="-Xms16m -Xmx32m"

# for twiddle.log
cd ${HINEMOS_HOME}/var/log

########################################
#  Local Variable
########################################

SERVICE="user:service=HinemosService,name=HinemosService"

########################################
#  Local Message
########################################

# INFO
MSG_I001="successful in pausing schedulers."
MSG_I002="successful in running schedulers."
MSG_I003="successful in restart all trigger."

# WARN
MSG_W001="all scheduler is already paused."
MSG_W002="all scheduler is already running."

# ERROR
MSG_E001="failed to execute twiddle.sh. "
MSG_E006="failed to access MBean (${SERVICE})."

########################################
# Function
########################################

#
# show usage
#
function usage {
	echo "usage : ${PROG} [-s|-d|-R|-P]"
	echo "   ${PROG} -s : show scheduler's status."
	echo "   ${PROG} -d : show scheduler's detail."
	echo "   ${PROG} -r : restart all trigger."
	echo "   ${PROG} -R : run scheduler. (restart monitoring and scheduled jobs)"
	echo "   ${PROG} -P : pause scheduler. (pause monitoring and scheduled jobs)"
}

#
# show status
#
function status {
	${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke ${SERVICE} printSchedulerStatus
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG_E006}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi
	
	return 0
}

#
# show detail
#
function detail {
	${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke ${SERVICE} printSchedulerDetail
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG_E006}"
		RET=$((16 + ${RET}))
		return ${RET}		
	fi
	
	return 0
}

#
# restart all triggers
#
function restart_all_trigger {
	${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke user:service=QuartzService,name=QuartzService resetAllSchedule > /dev/null
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG_E001}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi

	Logging "QuartzService:    ${MSG_I003}"

	${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke user:service=QuartzService,name=QuartzRAMService resetAllSchedule > /dev/null
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG_E001}"
		RET=$((16 + ${RET}))
		return ${RET}
	fi

	Logging "QuartzRAMService: ${MSG_I003} "

	return 0
}

#
# pause scheduler
#
function pause {
	if [ `${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke ${SERVICE} printSchedulerStatus | grep PAUSED | wc -l` -eq 2 ]
	then
		Logging "${MSG_W001}"
		return 0
	fi
	
	${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke ${SERVICE} pauseScheduler > /dev/null 2>&1
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG_E006}"
		RET=$((16 + ${RET})) 
		return ${RET}
	fi
	
	Logging "${MSG_I001}"
	return 0
}

#
# run scheduler
#
function run {
	if [ `${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke ${SERVICE} printSchedulerStatus | grep RUNNING | wc -l` -eq 2 ]
	then
		Logging "${MSG_W002}"
		return 0
	fi
	
	${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099 invoke ${SERVICE} startScheduler > /dev/null 2>&1 
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "${MSG_E006}"
		RET=$((16 + ${RET})) 
		return ${RET}
	fi
	
	Logging "${MSG_I002}"
	return 0
}

########################################
# SHELL
########################################

# check parameters
for OPT in $@
do
	case $OPT in
		--help)
			usage
			exit 0
			;;
	esac
done

if [ ! $# = 1 ]
then
	ExitIllegalArgumentError
fi

# check process
CheckJBossProcessRunning


# main
while getopts sdrRP OPT
do
	case $OPT in
		s)
			status
			;;
		d)
			detail
			;;
		r)
			restart_all_trigger
			;;
		R)
			run
			;;
		P)
			pause
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi

########################################
# Termination Processing
########################################

exit 0
