#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################

DBHOST=localhost
DBPORT=24001
DBUSER=hinemos
DBNAME=hinemos
DBPASSWORD=hinemos

MODE=CLUSTER

########################################
#  Local Message
########################################

# INFO
MSG_I001="executing full vacuum for Hinemos RDBMS Server (PostgreSQL)."
MSG_I002="executing cluster for Hinemos RDBMS Server (PostgreSQL)."
MSG_I003="executing reindex for Hinemos RDBMS Server (PostgreSQL)."
MSG_I101="successful in executing reclaim database."

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="failed to reclaim database."
MSG_E002="failed to reindex database."

########################################
# Function
########################################

#
# show usage
#
function usage {
	echo "usage : ${PROG} [-c] [-F] [-w] [password]"
	echo "options:"
	echo "  -c         cluster all previously clustered tables in a database."
	echo "  -F         execute full vacuum. (shrink physical size of database, but takes long time.)"
	echo "  -w passwd  set password (for Hinemos RDBM Server)"
}

########################################
# SHELL
########################################

# help chekc
for OPT in $@
do
	case $OPT in
		--help)
			usage
			exit 0
			;;
	esac
done


# check parameters
while getopts Fcw: OPT
do
	case $OPT in
		F)
			MODE=FULLVACUUM
			;;
		c)
			MODE=CLUSTER
			;;
		w)
			PASSWD=$OPTARG
			;;
		*)
			ExitIllegalOptionErrorWithoutLogger
			;;
	esac
done

shift $(( $OPTIND - 1 ))

if [ ! $# = 0 ]
then
	ExitIllegalArgumentError
fi


# check process
CheckJBossProcessStopped
CheckPostgreSQLProcessRunning

# main
ReadPostgreSQLPasswd

if [ "${MODE}" = "FULLVACUUM" ]
then
	Logging "${MSG_I001}"
	MSG=`${PG_HOME}/bin/vacuumdb -p ${DBPORT} -h ${DBHOST} -U ${DBUSER} -z -f -d ${DBNAME} 2>&1`
	RET=$?
	
	if [ ${RET} -ne 0 ]
	then
		Logging "$MSG"
		Logging "${MSG_E001}"
		RET=$((16 + ${RET}))
		exit ${RET}
	fi

	# exec reindex
	Logging "${MSG_I003}"
	MSG=`${PG_HOME}/bin/reindexdb -p ${DBPORT} -h ${DBHOST} -U ${DBUSER} -d ${DBNAME} 2>&1`
	RET=$?
	if [ ${RET} -ne 0 ]
	then
		Logging "$MSG"
		Logging "${MSG_E002}"
		RET=$((16 + ${RET}))
		exit ${RET}
	fi
else 
	Logging "${MSG_I002}"
	MSG=`${PG_HOME}/bin/clusterdb -p ${DBPORT} -h ${DBHOST} -U ${DBUSER} -d ${DBNAME} 2>&1`
	RET=$?
	
	if [ ${RET} -ne 0 ]
	then
		Logging "$MSG"
		Logging "${MSG_E001}"
		RET=$((16 + ${RET}))
		exit ${RET}
	fi
fi


########################################
# Termination Processing
########################################

Logging "${MSG_I101}"
exit 0
