#!/bin/bash
#
# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details
#
# Born Shell Common Utilities for Hinemos
#
# <description>
#  This script is designed for Hinemos 
#
# <usage>
#  . hinemos_utility.sh
#
# <return>
#  
#
# <dependency>
#  
#
# $Id:$

export PROG=`basename $0`

MSG_CE011_01="$0: illegal argument."
MSG_CE011_02="Try \`$0 --help' for more information."
MSG_CE012_01="$0: illegal option."
MSG_CE012_02="Try \`$0 --help' for more information."
MSG_CE021="PID file (${HINEMOS_JBOSS_PID}) exists. JBoss may be running."
MSG_CE022="PID file (${HINEMOS_JBOSS_PID}) does not exists. JBoss may be stopped."
MSG_CE023="PID file (${HINEMOS_PG_PID}) does not exists. PostgreSQL may be stopped."
MSG_CE024="failed to access Hinemos RDBMS Server (PostgreSQL). check status of Hinemos RDBMS Server."
MSG_CE061="incorrect user."

function ExitIllegalArgumentError() {
	Logging "${MSG_CE011_01}"
	Logging "${MSG_CE011_02}"
	exit 1
}

function ExitIllegalOptionErrorWithoutLogger() {
	# 以下のメッセージは標準エラーにはBuiltinコマンドが出力するためここではlogger出力のみ行う
	logger "${PROG} ${MSG_CE012_01}"
	Logging "${MSG_CE012_02}"
	exit 1
}

function CheckUser() {
	CURRENT_USER=`/usr/bin/whoami`
	if [ "x"$1 != "x"${CURRENT_USER} ]
	then
		Logging "${MSG_CE061} current user is not $1."
		exit 6
	fi
}

#
# PG_PID is set to the PosgreSQL processi id.
# PG_STATUS is set to the PosgreSQL status.
#
function CheckPostgreSQLStatus() {
	PG_ERROR_BASE_CODE=32
	if [ ! -f ${HINEMOS_PG_PID} ]
	then
		PG_PID=""
		PG_STATUS="(stopped)"
		RETURN_CODE=$(($PG_ERROR_BASE_CODE + 0))
	else
		PG_PID=`head -n 1 ${HINEMOS_PG_PID}`
		if [ "x"${PG_PID} != "x" ] && [ `ps --no-headers --pid ${PG_PID} e | grep "${PG_HOME}/bin/postgres -D ${PGDATA}" | wc -l` -eq 0 ]
		then
			PG_PID=""
			PG_STATUS="(stopped)"
			RETURN_CODE=$(($PG_ERROR_BASE_CODE + 1))
		else
			# check availability of PostgreSQL
			#${PG_HOME}/bin/psql -h ${DBHOST} -p ${DBPORT} -U ${DBUSER} -d ${DBNAME} -A -t -c "SELECT 1" > /dev/null 2>&1
			#RET=$?
			#if [ ${RET} -ne 0 ]
			#then
			#	PG_STATUS="(stopped)"
			#	RETURN_CODE=$(($PG_ERROR_BASE_CODE + 2))
			#else
				PG_STATUS="(running)"
				RETURN_CODE=0
			#fi
		fi
	fi
	return ${RETURN_CODE}
}


#
# JBOSS_PID is set to the JBoss processi id.
# JBOSS_STATUS is set to the JBoss status.
#
function CheckJBossStatus() {
	JBOSS_ERROR_BASE_CODE=64
	if [ ! -f ${HINEMOS_JBOSS_PID} ]
	then
		JBOSS_PID=""
		JBOSS_STATUS="(stopped)"
		RETURN_CODE=$(($JBOSS_ERROR_BASE_CODE + 0))
	else
		read JBOSS_PID < ${HINEMOS_JBOSS_PID}
		if [ "x"${JBOSS_PID} != "x" ] && [ `ps --no-headers --pid ${JBOSS_PID} e | grep "${JAVA_HOME}/bin/java.*org.jboss.Main" | wc -l` -eq 0 ]
		then
			JBOSS_PID=""
			JBOSS_STATUS="(stopped)"
			RETURN_CODE=$(($JBOSS_ERROR_BASE_CODE + 4))
		else
			# for twiddle.log
			cd ${HINEMOS_HOME}/var/log
		
			export JAVA_OPTS="-Xms16m -Xmx32m"
			RET_TWIDDLE=`${JBOSS_HOME}/bin/twiddle.sh --server jnp://${IP_ADDRESS}:1099/ get jboss.system:type=Server Started`
			RET=$?
			if [ ${RET} -ne 0 ]
			then
				JBOSS_STATUS="(stopped)"
				RETURN_CODE=$(($JBOSS_ERROR_BASE_CODE + 8))
			else
				if [ "x${RET_TWIDDLE}" != "xStarted=true" ]
				then
					JBOSS_STATUS="(initializing)"
					RETURN_CODE=$(($JBOSS_ERROR_BASE_CODE + 16))
				else
					JBOSS_STATUS="(running)"
					RETURN_CODE=0
				fi
			fi
		fi
	fi
	return ${RETURN_CODE}
}


function CheckHinemosManagerStatus() {
	# PostgreSQL
	CheckPostgreSQLStatus
	PG_EXIT_CODE=$?

	# JBoss
	CheckJBossStatus
	JBOSS_EXIT_CODE=$?

	if [ "x"${PG_PID} != "x" ] && [ "x"${JBOSS_PID} != "x" ]
	then
		Logging "${MSG_I001}"
	else
		Logging "${MSG_I002}"
	fi

	# output PID
	Logging "${MSG_I003} ${JBOSS_PID} ${JBOSS_STATUS}"
	Logging "${MSG_I004} ${PG_PID} ${PG_STATUS}"

	return $((${JBOSS_EXIT_CODE} + ${PG_EXIT_CODE})) 
}


function CheckJBossProcessStopped() {
	if [ -f ${HINEMOS_JBOSS_PID} ]
	then
		Logging "${MSG_CE021}"
		exit 2
	fi
}

function CheckJBossProcessRunning() {
	if [ ! -f ${HINEMOS_JBOSS_PID} ]
	then
		Logging "${MSG_CE022}"
		exit 2
	fi
}

function CheckPostgreSQLProcessRunning() {
	if [ ! -f ${HINEMOS_PG_PID} ]
	then
		Logging "${MSG_CE023}"
		exit 2
	fi
}

function ReadPostgreSQLPasswd() {
	if [ "x${PASSWD}" = "x" ]
	then
		stty -echo
		read -p "input a password of Hinemos RDBM Server (default '${DBPASSWORD}') : " PASSWD
		stty echo
		echo
	fi
	export PGPASSWORD=${PASSWD:-${DBPASSWORD}}
}


function Logging() {
	MODE=$2
	OPTS="-e"

	case ${MODE} in
		withline)
			EchoLine
			Logging "$1"
			EchoLine
			return 0
			;;
 		noreturn)
			OPTS="${OPTS} -n"
			;;
		*)
			;;
	esac

	echo ${OPTS} "$1" >&2

	/usr/bin/logger "${PROG} $1"
}

function EchoOK() {
	Logging "[ OK ]"
}

function EchoNG() {
	Logging "[ NG ]"
}

function EchoLine() {
	Logging "--------------------------------------------------"
}

