#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################

########################################
#  Local Message
########################################

# INFO
MSG_I001="checking database directory(${PG_DATA})..."
MSG_I002="checking current user(${USER})..."
MSG_I003="initializing database directory(${PG_DATA})..."
MSG_I004="configuring database..."
MSG_I005="starting up database..."
MSG_I006="configuring database users..."
MSG_I007="configuring database schemas and loading initial data..."
MSG_I009="shutting down database..."
MSG_I010="configuring authentication..."

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="usage : ${PROG} language(en, jp...)"
MSG_E002="not supported language"

########################################
# Function
########################################

function EchoOK() {
        Logging " done"
}

function EchoNG() {
        Logging " failed"
}

#
# show usage
#
function usage {
	Logging "${MSG_E001}"
	return 1
}

########################################
# SHELL
########################################

# check parameters
if [ $# -gt 1 ]; then
	usage
	exit 1
fi

for ARGS in "$@"
do
	LANGUAGE=${ARGS}
done

if [ ! -e ${HINEMOS_HOME}/sbin/db_init/${LANGUAGE}_hinemos_data.sql ]
then
	Logging "${MSG_E002} : ${LANGUAGE}"
	exit 1
fi

# check database directory
Logging "${MSG_I001}" noreturn
if [ -e ${PG_DATA} ]
then
	EchoNG
	exit 1
fi
EchoOK

# check user executed
Logging "${MSG_I002}" noreturn
if [ "x"${USER} != "x"${HINEMOS_PG_USER} ]
then
	EchoNG
	exit 1
fi
EchoOK

# initialize database directory
Logging "${MSG_I003}" noreturn
${PG_HOME}/bin/initdb --no-locale --encoding=UTF-8 -D ${PG_DATA} > /dev/null 2>&1
RET=$?
if [ ${RET} -ne 0 ]
then
	EchoNG
	exit 1
fi
EchoOK

# symlink configuration file
Logging "${MSG_I004}" noreturn
rm -f ${PG_DATA}/postgresql.conf && ln -s ../../etc/postgresql.conf ${PG_DATA}
RET=$?
if [ ${RET} -ne 0 ]
then
	EchoNG
	exit 1
fi
EchoOK

# startup database
Logging "${MSG_I005}" noreturn
${HINEMOS_HOME}/bin/pg_start.sh > /dev/null 2>&1
RET=$?
if [ ${RET} -ne 0 ]
then
	EchoNG
	exit 1
fi
EchoOK

# initialize database user
Logging "${MSG_I006}" noreturn
${PG_HOME}/bin/psql -q -p 24001 -d template1 -c "ALTER USER hinemos PASSWORD 'hinemos'" && \
${PG_HOME}/bin/psql -q -p 24001 -d template1 -c "CREATE ROLE hinemos_quartz WITH NOSUPERUSER INHERIT LOGIN PASSWORD 'hinemos_quartz' IN ROLE hinemos"
RET=$?
if [ ${RET} -ne 0 ]
then
	EchoNG
	exit 1
fi
EchoOK

# initialize database schema
Logging "${MSG_I007}" noreturn
${PG_HOME}/bin/psql -q -p 24001 template1 -c "CREATE DATABASE hinemos" && \
${PG_HOME}/bin/psql -q -p 24001 -f ${HINEMOS_HOME}/sbin/db_init/hinemos_schema_table.sql && \
${PG_HOME}/bin/psql -q -p 24001 -f ${HINEMOS_HOME}/sbin/db_init/${LANGUAGE}_hinemos_data.sql && \
${PG_HOME}/bin/psql -q -p 24001 -f ${HINEMOS_HOME}/sbin/db_init/hinemos_schema_constraint.sql && \
${PG_HOME}/bin/psql -q -p 24001 -f ${HINEMOS_HOME}/sbin/db_init/hinemos_trap_events.sql
RET=$?
if [ ${RET} -ne 0 ]
then
	EchoNG
	exit 1
fi
EchoOK

# initialize database(nodemap icon)
TMP_FILE=tmp_hinemos.sql
rm -f ${TMP_FILE}
for imgfile in node scope nw1.png pc1.png Hinemos_icon_32x32.gif
do
  echo INSERT INTO cc_map_icon_image values\(\'$imgfile\', E\'\\`od -v -w1 -A n -t oC ${HINEMOS_HOME}/sbin/db_init/img/$imgfile | tr ' \n' '\\\\'`\\012\'\)\; >> ${TMP_FILE}
done
imgfile=default
echo INSERT INTO cc_map_bg_image values\(\'$imgfile\', E\'\\`od -v -w1 -A n -t oC ${HINEMOS_HOME}/sbin/db_init/img/$imgfile | tr ' \n' '\\\\'`\\012\'\)\; >> ${TMP_FILE}
${PG_HOME}/bin/psql -q -p 24001 -U hinemos -f ${TMP_FILE}
RET=$?
rm -f ${TMP_FILE}
if [ ${RET} -ne 0 ]
then
	EchoNG
	exit 1
fi
EchoOK

# shutdown database
Logging "${MSG_I009}" noreturn
${HINEMOS_HOME}/bin/pg_stop.sh > /dev/null 2>&1
RET=$?
if [ ${RET} -ne 0 ]
then
	EchoNG
	exit 1
fi
EchoOK

# symlink auth configuration
Logging "${MSG_I010}" noreturn
rm -f ${PG_DATA}/pg_hba.conf && ln -s ../../etc/pg_hba.conf ${PG_DATA}
RET=$?
if [ ${RET} -ne 0 ]
then
	EchoNG
	exit 1
fi
EchoOK

########################################
# Termination Processing
########################################

exit 0
