--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: cc_acc_lock; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_acc_lock (
    lock_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_acc_lock OWNER TO hinemos;

--
-- Name: cc_cal_add_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_add_info (
    calendar_id character varying(64) NOT NULL,
    time_from timestamp without time zone NOT NULL,
    time_to timestamp without time zone NOT NULL,
    execute_flg smallint NOT NULL,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_cal_add_info OWNER TO hinemos;

--
-- Name: cc_cal_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_info (
    calendar_id character varying(64) NOT NULL,
    calendar_name character varying(256) NOT NULL,
    description character varying(256),
    start_time time without time zone,
    valid_time_from timestamp without time zone NOT NULL,
    valid_time_to timestamp without time zone NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_cal_info OWNER TO hinemos;

--
-- Name: cc_cal_weekday_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cal_weekday_info (
    calendar_id character varying(64) NOT NULL,
    weekday smallint NOT NULL,
    time_from time without time zone NOT NULL,
    time_to time without time zone NOT NULL,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_cal_weekday_info OWNER TO hinemos;

--
-- Name: cc_calculated_data; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_calculated_data (
    collectorid character varying(256) NOT NULL,
    item_code character varying(64) NOT NULL,
    display_name character varying(256) NOT NULL,
    date_time timestamp without time zone NOT NULL,
    facilityid character varying(64) NOT NULL,
    value double precision
);


ALTER TABLE public.cc_calculated_data OWNER TO hinemos;

--
-- Name: cc_cfg_facility; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_facility (
    facility_id character varying(64) NOT NULL,
    facility_name character varying(128) NOT NULL,
    facility_type integer NOT NULL,
    description character varying(256) NOT NULL,
    display_sort_order integer NOT NULL,
    valid smallint NOT NULL,
    create_user_id character varying(64) NOT NULL,
    create_datetime timestamp without time zone NOT NULL,
    modify_user_id character varying(64) NOT NULL,
    modify_datetime timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_cfg_facility OWNER TO hinemos;

--
-- Name: cc_cfg_facility_relation; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_facility_relation (
    parent_facility_id character varying(64) NOT NULL,
    child_facility_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_cfg_facility_relation OWNER TO hinemos;

--
-- Name: cc_cfg_node; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node (
    facility_id character varying(64) NOT NULL,
    platform_family character varying(128) NOT NULL,
    hardware_type character varying(128) NOT NULL,
    icon_image character varying(256) NOT NULL,
    snmp_port integer NOT NULL,
    snmp_community character varying(64) NOT NULL,
    snmp_version character varying(8) NOT NULL,
    snmp_timeout integer NOT NULL,
    snmp_retry_count integer NOT NULL,
    snmp_proxy character varying(512) NOT NULL,
    wbem_user character varying(64) NOT NULL,
    wbem_user_password character varying(64) NOT NULL,
    wbem_port integer NOT NULL,
    wbem_protocol character varying(32) NOT NULL,
    wbem_timeout integer NOT NULL,
    wbem_retry_count integer NOT NULL,
    dhcp_client smallint NOT NULL,
    ip_address_type integer NOT NULL,
    ip_address_version smallint NOT NULL,
    ip_address_v4 character varying(16) NOT NULL,
    ip_address_v6 character varying(40) NOT NULL,
    node_name character varying(128) NOT NULL,
    os_name character varying(256) NOT NULL,
    os_release character varying(256) NOT NULL,
    os_version character varying(256) NOT NULL,
    character_set character varying(16) NOT NULL,
    virtualization_node_type character varying(64) NOT NULL,
    vm_management_node character varying(64) NOT NULL,
    vm_index integer NOT NULL,
    vm_name character varying(128) NOT NULL,
    virtualization_solution character varying(256) NOT NULL,
    vm_id character varying(256) NOT NULL,
    vm_user character varying(64) NOT NULL,
    vm_user_password character varying(64) NOT NULL,
    vm_protocol character varying(32) NOT NULL,
    administrator character varying(256) NOT NULL,
    contact character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node OWNER TO hinemos;

--
-- Name: cc_cfg_node_device; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node_device (
    facility_id character varying(64) NOT NULL,
    device_type character varying(32) NOT NULL,
    device_index integer NOT NULL,
    device_name character varying(128) NOT NULL,
    device_display_name character varying(256) NOT NULL,
    device_snmp_oid character varying(256) NOT NULL,
    device_description character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node_device OWNER TO hinemos;

--
-- Name: cc_cfg_node_filesystem; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node_filesystem (
    facility_id character varying(64) NOT NULL,
    fs_index integer NOT NULL,
    fs_mount_point character varying(512) NOT NULL,
    fs_display_name character varying(256) NOT NULL,
    fs_type character varying(32) NOT NULL,
    fs_snmp_oid character varying(1024) NOT NULL,
    fs_description character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node_filesystem OWNER TO hinemos;

--
-- Name: cc_cfg_node_hostname; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node_hostname (
    facility_id character varying(64) NOT NULL,
    hostname character varying(128) NOT NULL
);


ALTER TABLE public.cc_cfg_node_hostname OWNER TO hinemos;

--
-- Name: cc_cfg_node_note; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_node_note (
    facility_id character varying(64) NOT NULL,
    note_id integer NOT NULL,
    note character varying(1024) NOT NULL
);


ALTER TABLE public.cc_cfg_node_note OWNER TO hinemos;

--
-- Name: cc_cfg_user; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_user (
    user_id character varying(64) NOT NULL,
    user_name character varying(128) NOT NULL,
    password character varying(64) NOT NULL,
    user_type character varying(16) NOT NULL,
    description character varying(256) NOT NULL,
    create_user_id character varying(64) NOT NULL,
    create_datetime timestamp without time zone NOT NULL,
    modify_user_id character varying(64) NOT NULL,
    modify_datetime timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_cfg_user OWNER TO hinemos;

--
-- Name: cc_cfg_user_role; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_cfg_user_role (
    user_id character varying(64) NOT NULL,
    user_role character varying(64) NOT NULL
);


ALTER TABLE public.cc_cfg_user_role OWNER TO hinemos;

--
-- Name: cc_collector_calc_method_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_calc_method_mst (
    calc_method character varying(256) NOT NULL,
    class_name character varying(256),
    expression text
);


ALTER TABLE public.cc_collector_calc_method_mst OWNER TO hinemos;

--
-- Name: cc_collector_category_collect_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_category_collect_mst (
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    category_code character varying(64) NOT NULL,
    collect_method character varying(64) NOT NULL
);


ALTER TABLE public.cc_collector_category_collect_mst OWNER TO hinemos;

--
-- Name: cc_collector_category_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_category_mst (
    category_code character varying(64) NOT NULL,
    category_name character varying(256)
);


ALTER TABLE public.cc_collector_category_mst OWNER TO hinemos;

--
-- Name: cc_collector_device_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_device_info (
    collectorid character varying(256) NOT NULL,
    facilityid character varying(64) NOT NULL,
    display_name character varying(256) NOT NULL,
    device_name character varying(256) NOT NULL,
    index bigint,
    device_id character varying(64),
    device_type character varying(256)
);


ALTER TABLE public.cc_collector_device_info OWNER TO hinemos;

--
-- Name: cc_collector_item; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_item (
    collectorid character varying(256) NOT NULL,
    item_code character varying(64) NOT NULL,
    display_name character varying(256) NOT NULL
);


ALTER TABLE public.cc_collector_item OWNER TO hinemos;

--
-- Name: cc_collector_item_calc_method_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_item_calc_method_mst (
    collect_method character varying(64) NOT NULL,
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    item_code character varying(64) NOT NULL,
    calc_method character varying(256) NOT NULL
);


ALTER TABLE public.cc_collector_item_calc_method_mst OWNER TO hinemos;

--
-- Name: cc_collector_item_code_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_item_code_mst (
    item_code character varying(64) NOT NULL,
    category_code character varying(64) NOT NULL,
    parent_item_code character varying(256),
    item_name character varying(256) NOT NULL,
    measure character varying(64),
    device_support smallint NOT NULL,
    device_type character varying(64),
    graph_range smallint NOT NULL
);


ALTER TABLE public.cc_collector_item_code_mst OWNER TO hinemos;

--
-- Name: cc_collector_platform_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_platform_mst (
    platform_id character varying(64) NOT NULL,
    platform_name character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_collector_platform_mst OWNER TO hinemos;

--
-- Name: cc_collector_polling_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_polling_mst (
    collect_method character varying(64) NOT NULL,
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    item_code character varying(64) NOT NULL,
    variable_id character varying(64) NOT NULL,
    entry_key character varying(1024) NOT NULL,
    value_type character varying(64) NOT NULL,
    polling_target character varying(1024) NOT NULL,
    failure_value character varying(256)
);


ALTER TABLE public.cc_collector_polling_mst OWNER TO hinemos;

--
-- Name: cc_collector_profile; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_profile (
    collectorid character varying(256) NOT NULL,
    collector_type smallint,
    label character varying(1024),
    scheduled_start_date timestamp without time zone,
    scheduled_stop_date timestamp without time zone,
    start_date timestamp without time zone,
    stop_date timestamp without time zone,
    target_facilityid character varying(64),
    scope_path character varying(1024),
    interval_sec integer,
    period_min integer,
    presave_period integer
);


ALTER TABLE public.cc_collector_profile OWNER TO hinemos;

--
-- Name: cc_collector_scope_relation; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_scope_relation (
    collectorid character varying(256) NOT NULL,
    facilityid character varying(64) NOT NULL,
    parent_facilityid character varying(64) NOT NULL
);


ALTER TABLE public.cc_collector_scope_relation OWNER TO hinemos;

--
-- Name: cc_collector_scope_snap; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_scope_snap (
    collectorid character varying(256) NOT NULL,
    facilityid character varying(64) NOT NULL,
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    facility_name character varying(256),
    facility_type character varying(16)
);


ALTER TABLE public.cc_collector_scope_snap OWNER TO hinemos;

--
-- Name: cc_collector_status; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_collector_status (
    collectorid character varying(256) NOT NULL,
    run_status smallint,
    error_status smallint,
    end_status smallint,
    count bigint,
    last_collect_date timestamp without time zone
)
WITH (fillfactor=90);


ALTER TABLE public.cc_collector_status OWNER TO hinemos;

--
-- Name: cc_crun_cmd_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_cmd_mst (
    command_id character varying(64) NOT NULL,
    type_id character varying(64),
    order_no smallint NOT NULL,
    name_id character varying(256),
    command_type smallint NOT NULL,
    command character varying(256)
);


ALTER TABLE public.cc_crun_cmd_mst OWNER TO hinemos;

--
-- Name: cc_crun_cmd_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_cmd_param_mst (
    command_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    param_prefix character varying(64)
);


ALTER TABLE public.cc_crun_cmd_param_mst OWNER TO hinemos;

--
-- Name: cc_crun_end_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_end_mst (
    command_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);


ALTER TABLE public.cc_crun_end_mst OWNER TO hinemos;

--
-- Name: cc_crun_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_param_mst (
    param_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    param_type smallint NOT NULL
);


ALTER TABLE public.cc_crun_param_mst OWNER TO hinemos;

--
-- Name: cc_crun_param_select_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_param_select_mst (
    param_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    name_id character varying(256) NOT NULL,
    param_value character varying(4096)
);


ALTER TABLE public.cc_crun_param_select_mst OWNER TO hinemos;

--
-- Name: cc_crun_session; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session (
    session_id character varying(64) NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    type_id character varying(64) NOT NULL,
    command_id character varying(64),
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256),
    node_cnt smallint NOT NULL,
    wait_cnt smallint NOT NULL,
    running_cnt smallint NOT NULL,
    end_nomal_cnt smallint NOT NULL,
    end_warning_cnt smallint NOT NULL,
    end_abnomal_cnt smallint NOT NULL,
    status smallint NOT NULL
);


ALTER TABLE public.cc_crun_session OWNER TO hinemos;

--
-- Name: cc_crun_session_detail; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session_detail (
    session_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    facility_name character varying(256),
    message text,
    error_message text,
    status smallint NOT NULL,
    end_status smallint,
    end_value smallint
);


ALTER TABLE public.cc_crun_session_detail OWNER TO hinemos;

--
-- Name: cc_crun_session_param; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_session_param (
    session_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_value character varying(4096)
);


ALTER TABLE public.cc_crun_session_param OWNER TO hinemos;

--
-- Name: cc_crun_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_crun_type_mst (
    type_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_crun_type_mst OWNER TO hinemos;

--
-- Name: cc_device_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_device_type_mst (
    device_type character varying(64) NOT NULL,
    device_type_name character varying(256)
);


ALTER TABLE public.cc_device_type_mst OWNER TO hinemos;

--
-- Name: cc_event_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_event_log (
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    generation_date timestamp without time zone NOT NULL,
    facility_id character varying(64) NOT NULL,
    scope_text character varying(256) NOT NULL,
    application character varying(64) NOT NULL,
    message_id character varying(64) NOT NULL,
    message character varying(256) NOT NULL,
    message_org text,
    priority smallint NOT NULL,
    confirm_flg smallint NOT NULL,
    confirm_date timestamp without time zone,
    confirm_user character varying(64),
    duplication_count bigint NOT NULL,
    output_date timestamp without time zone NOT NULL,
    inhibited_flg smallint NOT NULL
);


ALTER TABLE public.cc_event_log OWNER TO hinemos;

--
-- Name: cc_event_multi_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_event_multi_info (
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    output_date timestamp without time zone NOT NULL,
    multi_id character varying(64) NOT NULL,
    duplication_count smallint NOT NULL
);


ALTER TABLE public.cc_event_multi_info OWNER TO hinemos;

--
-- Name: cc_job_command_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_command_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    start_command character varying(1024),
    stop_command character varying(1024),
    effective_user character varying(64),
    error_end_flg smallint NOT NULL,
    error_end_value smallint NOT NULL,
    argument_job_id character varying(64),
    argument character varying(1024)
);


ALTER TABLE public.cc_job_command_info OWNER TO hinemos;

--
-- Name: cc_job_command_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_command_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    start_command character varying(1024),
    stop_command character varying(1024),
    effective_user character varying(64),
    error_end_flg smallint NOT NULL,
    error_end_value smallint NOT NULL,
    argument_job_id character varying(64),
    argument character varying(1024)
);


ALTER TABLE public.cc_job_command_mst OWNER TO hinemos;

--
-- Name: cc_job_end_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_end_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);


ALTER TABLE public.cc_job_end_info OWNER TO hinemos;

--
-- Name: cc_job_end_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_end_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    end_status smallint NOT NULL,
    end_value smallint NOT NULL,
    end_value_from smallint NOT NULL,
    end_value_to smallint NOT NULL
);


ALTER TABLE public.cc_job_end_mst OWNER TO hinemos;

--
-- Name: cc_job_file_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_file_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    src_facility_id character varying(64) NOT NULL,
    dest_facility_id character varying(64) NOT NULL,
    src_file character varying(4096) NOT NULL,
    src_work_dir character varying(4096) NOT NULL,
    dest_directory character varying(4096) NOT NULL,
    dest_work_dir character varying(4096) NOT NULL,
    compression_flg smallint NOT NULL,
    check_flg smallint NOT NULL,
    effective_user character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_file_info OWNER TO hinemos;

--
-- Name: cc_job_file_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_file_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    process_mode smallint NOT NULL,
    src_facility_id character varying(64) NOT NULL,
    dest_facility_id character varying(64) NOT NULL,
    src_file character varying(4096) NOT NULL,
    src_work_dir character varying(4096) NOT NULL,
    dest_directory character varying(4096) NOT NULL,
    dest_work_dir character varying(4096) NOT NULL,
    compression_flg smallint NOT NULL,
    check_flg smallint NOT NULL,
    effective_user character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_file_mst OWNER TO hinemos;

--
-- Name: cc_job_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    job_name character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    job_type smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_info OWNER TO hinemos;

--
-- Name: cc_job_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    job_name character varying(64) NOT NULL,
    description character varying(256) NOT NULL,
    job_type smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_job_mst OWNER TO hinemos;

--
-- Name: cc_job_notice_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_notice_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    notice_type smallint NOT NULL,
    priority smallint NOT NULL,
    notify_group_id character varying(1024)
);


ALTER TABLE public.cc_job_notice_info OWNER TO hinemos;

--
-- Name: cc_job_notice_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_notice_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    notice_type smallint NOT NULL,
    priority smallint NOT NULL,
    notify_group_id character varying(1024)
);


ALTER TABLE public.cc_job_notice_mst OWNER TO hinemos;

--
-- Name: cc_job_param_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_param_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_type smallint NOT NULL,
    description character varying(256),
    value character varying(1024)
);


ALTER TABLE public.cc_job_param_info OWNER TO hinemos;

--
-- Name: cc_job_param_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_param_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    param_id character varying(64) NOT NULL,
    param_type smallint NOT NULL,
    description character varying(256),
    value character varying(1024)
);


ALTER TABLE public.cc_job_param_mst OWNER TO hinemos;

--
-- Name: cc_job_relation_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_relation_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    parent_jobunit_id character varying(64) NOT NULL,
    parent_job_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_relation_info OWNER TO hinemos;

--
-- Name: cc_job_relation_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_relation_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    parent_jobunit_id character varying(64) NOT NULL,
    parent_job_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_relation_mst OWNER TO hinemos;

--
-- Name: cc_job_session; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    schedule_date timestamp without time zone,
    operation_flg smallint NOT NULL,
    trigger_type smallint NOT NULL,
    trigger_info character varying(256) NOT NULL
);


ALTER TABLE public.cc_job_session OWNER TO hinemos;

--
-- Name: cc_job_session_job; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session_job (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    scope_text character varying(256),
    status smallint NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    end_value smallint,
    end_status smallint,
    result character varying(1024),
    end_staus_check_flg smallint,
    delay_notify_flg smallint
);


ALTER TABLE public.cc_job_session_job OWNER TO hinemos;

--
-- Name: cc_job_session_node; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_session_node (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    node_name character varying(256),
    status smallint NOT NULL,
    start_date timestamp without time zone,
    end_date timestamp without time zone,
    end_value smallint,
    message text,
    agent_check smallint,
    check_date timestamp without time zone,
    retry_count smallint,
    result character varying(1024),
    status_buffer smallint
);


ALTER TABLE public.cc_job_session_node OWNER TO hinemos;

--
-- Name: cc_job_start_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    condition_type smallint NOT NULL,
    suspend smallint NOT NULL,
    skip smallint NOT NULL,
    skip_end_status smallint NOT NULL,
    skip_end_value smallint NOT NULL,
    unmatch_end_flg smallint NOT NULL,
    unmatch_end_status smallint NOT NULL,
    unmatch_end_value smallint NOT NULL,
    calendar smallint NOT NULL,
    calendar_id character varying(64),
    calendar_end_value smallint NOT NULL,
    start_delay smallint NOT NULL,
    start_delay_session smallint NOT NULL,
    start_delay_session_value smallint NOT NULL,
    start_delay_time smallint NOT NULL,
    start_delay_time_value time without time zone,
    start_delay_condition_type smallint NOT NULL,
    start_delay_notify smallint NOT NULL,
    start_delay_notify_priority smallint NOT NULL,
    start_delay_operation smallint NOT NULL,
    start_delay_operation_type smallint NOT NULL,
    start_delay_operation_end_value smallint NOT NULL,
    end_delay smallint NOT NULL,
    end_delay_session smallint NOT NULL,
    end_delay_session_value smallint NOT NULL,
    end_delay_job smallint NOT NULL,
    end_delay_job_value smallint NOT NULL,
    end_delay_time smallint NOT NULL,
    end_delay_time_value time without time zone,
    end_delay_condition_type smallint NOT NULL,
    end_delay_notify smallint NOT NULL,
    end_delay_notify_priority smallint NOT NULL,
    end_delay_operation smallint NOT NULL,
    end_delay_operation_type smallint NOT NULL,
    end_delay_operation_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_info OWNER TO hinemos;

--
-- Name: cc_job_start_job_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_job_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    target_jobunit_id character varying(64) NOT NULL,
    target_job_id character varying(64) NOT NULL,
    target_job_type smallint NOT NULL,
    target_job_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_job_info OWNER TO hinemos;

--
-- Name: cc_job_start_job_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_job_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    target_jobunit_id character varying(64) NOT NULL,
    target_job_id character varying(64) NOT NULL,
    target_job_type smallint NOT NULL,
    target_job_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_job_mst OWNER TO hinemos;

--
-- Name: cc_job_start_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    condition_type smallint NOT NULL,
    suspend smallint NOT NULL,
    skip smallint NOT NULL,
    skip_end_status smallint NOT NULL,
    skip_end_value smallint NOT NULL,
    unmatch_end_flg smallint NOT NULL,
    unmatch_end_status smallint NOT NULL,
    unmatch_end_value smallint NOT NULL,
    calendar smallint NOT NULL,
    calendar_id character varying(64),
    calendar_end_value smallint NOT NULL,
    start_delay smallint NOT NULL,
    start_delay_session smallint NOT NULL,
    start_delay_session_value smallint NOT NULL,
    start_delay_time smallint NOT NULL,
    start_delay_time_value time without time zone,
    start_delay_condition_type smallint NOT NULL,
    start_delay_notify smallint NOT NULL,
    start_delay_notify_priority smallint NOT NULL,
    start_delay_operation smallint NOT NULL,
    start_delay_operation_type smallint NOT NULL,
    start_delay_operation_end_value smallint NOT NULL,
    end_delay smallint NOT NULL,
    end_delay_session smallint NOT NULL,
    end_delay_session_value smallint NOT NULL,
    end_delay_job smallint NOT NULL,
    end_delay_job_value smallint NOT NULL,
    end_delay_time smallint NOT NULL,
    end_delay_time_value time without time zone,
    end_delay_condition_type smallint NOT NULL,
    end_delay_notify smallint NOT NULL,
    end_delay_notify_priority smallint NOT NULL,
    end_delay_operation smallint NOT NULL,
    end_delay_operation_type smallint NOT NULL,
    end_delay_operation_end_value smallint NOT NULL
);


ALTER TABLE public.cc_job_start_mst OWNER TO hinemos;

--
-- Name: cc_job_start_time_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_time_info (
    session_id character varying(64) NOT NULL,
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    start_time time without time zone NOT NULL
);


ALTER TABLE public.cc_job_start_time_info OWNER TO hinemos;

--
-- Name: cc_job_start_time_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_start_time_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    start_time time without time zone NOT NULL
);


ALTER TABLE public.cc_job_start_time_mst OWNER TO hinemos;

--
-- Name: cc_job_user_relation_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_job_user_relation_mst (
    jobunit_id character varying(64) NOT NULL,
    job_id character varying(64) NOT NULL,
    user_id character varying(64) NOT NULL
);


ALTER TABLE public.cc_job_user_relation_mst OWNER TO hinemos;

--
-- Name: cc_log_transfer_file_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_log_transfer_file_info (
    transfer_id character varying(64) NOT NULL,
    file_path character varying(4096) NOT NULL,
    run_interval smallint,
    existence_flg smallint,
    valid_flg smallint NOT NULL
);


ALTER TABLE public.cc_log_transfer_file_info OWNER TO hinemos;

--
-- Name: cc_log_transfer_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_log_transfer_info (
    transfer_id character varying(64) NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    valid_flg smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_log_transfer_info OWNER TO hinemos;

--
-- Name: cc_mail_template_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_mail_template_info (
    mail_template_id character varying(64) NOT NULL,
    description character varying(256),
    subject character varying(256),
    body text,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_mail_template_info OWNER TO hinemos;

--
-- Name: cc_map_association; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_association (
    map_id character varying(64) NOT NULL,
    source character varying(64) NOT NULL,
    target character varying(64) NOT NULL
);


ALTER TABLE public.cc_map_association OWNER TO hinemos;

--
-- Name: cc_map_bg_image; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_bg_image (
    filename character varying(64) NOT NULL,
    filedata bytea NOT NULL
);


ALTER TABLE public.cc_map_bg_image OWNER TO hinemos;

--
-- Name: cc_map_icon_image; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_icon_image (
    filename character varying(64) NOT NULL,
    filedata bytea NOT NULL
);


ALTER TABLE public.cc_map_icon_image OWNER TO hinemos;

--
-- Name: cc_map_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_info (
    map_id character varying(64) NOT NULL,
    background_image character varying(64)
);


ALTER TABLE public.cc_map_info OWNER TO hinemos;

--
-- Name: cc_map_position; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_map_position (
    map_id character varying(64) NOT NULL,
    element_id character varying(64) NOT NULL,
    x integer,
    y integer
);


ALTER TABLE public.cc_map_position OWNER TO hinemos;

--
-- Name: cc_monitor_agent_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_agent_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    check_job_agent smallint,
    check_log_agent smallint
);


ALTER TABLE public.cc_monitor_agent_info OWNER TO hinemos;

--
-- Name: cc_monitor_http_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_http_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    request_url character varying(2083) NOT NULL,
    url_replace smallint,
    proxy_set smallint,
    proxy_host character varying(64),
    proxy_port smallint,
    timeout smallint
);


ALTER TABLE public.cc_monitor_http_info OWNER TO hinemos;

--
-- Name: cc_monitor_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    monitor_type smallint NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    run_interval smallint,
    calendar_id character varying(64),
    monitor_block smallint,
    determination_id character varying(64),
    failure_priority smallint,
    notify_group_id character varying(1024),
    application character varying(64),
    failure_message_id character varying(64),
    failure_message character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64),
    timeout smallint
);


ALTER TABLE public.cc_monitor_info OWNER TO hinemos;

--
-- Name: cc_monitor_numeric_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_numeric_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    threshold_upper_limit double precision NOT NULL,
    threshold_lower_limit double precision NOT NULL,
    message_id character varying(64),
    message character varying(256)
);


ALTER TABLE public.cc_monitor_numeric_value_info OWNER TO hinemos;

--
-- Name: cc_monitor_perf_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_perf_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    collector_id character varying(256),
    item_code character varying(256),
    device_index bigint,
    device_name character varying(256) NOT NULL,
    display_name character varying(256)
);


ALTER TABLE public.cc_monitor_perf_info OWNER TO hinemos;

--
-- Name: cc_monitor_ping_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_ping_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    run_count smallint,
    run_interval smallint,
    timeout smallint
);


ALTER TABLE public.cc_monitor_ping_info OWNER TO hinemos;

--
-- Name: cc_monitor_port_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_port_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    port_number integer,
    run_count smallint,
    run_interval smallint,
    timeout smallint,
    service_id character varying(64)
);


ALTER TABLE public.cc_monitor_port_info OWNER TO hinemos;

--
-- Name: cc_monitor_process_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_process_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    command character varying(256) NOT NULL,
    param character varying(256)
);


ALTER TABLE public.cc_monitor_process_info OWNER TO hinemos;

--
-- Name: cc_monitor_process_method_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_process_method_mst (
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    collect_method character varying(64) NOT NULL
);


ALTER TABLE public.cc_monitor_process_method_mst OWNER TO hinemos;

--
-- Name: cc_monitor_process_polling_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_process_polling_mst (
    collect_method character varying(64) NOT NULL,
    platform_id character varying(64) NOT NULL,
    sub_platform_id character varying(64) NOT NULL,
    variable_id character varying(64) NOT NULL,
    entry_key character varying(1024) NOT NULL,
    polling_target character varying(1024) NOT NULL
);


ALTER TABLE public.cc_monitor_process_polling_mst OWNER TO hinemos;

--
-- Name: cc_monitor_protocol_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_protocol_mst (
    service_id character varying(64) NOT NULL,
    service_name character varying(64) NOT NULL,
    description character varying(256),
    default_port_number integer,
    class_name character varying(256)
);


ALTER TABLE public.cc_monitor_protocol_mst OWNER TO hinemos;

--
-- Name: cc_monitor_snmp_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_snmp_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    community_name character varying(64) NOT NULL,
    snmp_port integer NOT NULL,
    snmp_oid character varying(1024) NOT NULL,
    snmp_version character varying(64) NOT NULL,
    convert_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_snmp_info OWNER TO hinemos;

--
-- Name: cc_monitor_snmp_value; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_snmp_value (
    monitor_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    value double precision NOT NULL,
    get_date timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_monitor_snmp_value OWNER TO hinemos;

--
-- Name: cc_monitor_sql_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_sql_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    connection_url character varying(256) NOT NULL,
    connection_user character varying(64) NOT NULL,
    connection_password character varying(64) NOT NULL,
    query character varying(1024) NOT NULL,
    jdbc_driver character varying(256) NOT NULL
);


ALTER TABLE public.cc_monitor_sql_info OWNER TO hinemos;

--
-- Name: cc_monitor_status; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_status (
    facility_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    last_update timestamp without time zone NOT NULL,
    counter bigint NOT NULL
);


ALTER TABLE public.cc_monitor_status OWNER TO hinemos;

--
-- Name: cc_monitor_string_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_string_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    description character varying(256),
    process_type smallint NOT NULL,
    pattern character varying(1024) NOT NULL,
    priority smallint NOT NULL,
    message_id character varying(64),
    message character varying(256),
    notify_group_id character varying(1024),
    valid_flg smallint NOT NULL
);


ALTER TABLE public.cc_monitor_string_value_info OWNER TO hinemos;

--
-- Name: cc_monitor_truth_value_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_monitor_truth_value_info (
    monitor_type_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    truth_value smallint NOT NULL,
    message_id character varying(64),
    message character varying(256)
);


ALTER TABLE public.cc_monitor_truth_value_info OWNER TO hinemos;

--
-- Name: cc_notify_command_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_command_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    valid_flg smallint NOT NULL,
    command character varying(1024),
    effective_user character varying(64),
    set_environment smallint NOT NULL,
    command_timeout bigint NOT NULL
);


ALTER TABLE public.cc_notify_command_info OWNER TO hinemos;

--
-- Name: cc_notify_event_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_event_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    event_normal_flg smallint NOT NULL,
    event_normal_state smallint NOT NULL
);


ALTER TABLE public.cc_notify_event_info OWNER TO hinemos;

--
-- Name: cc_notify_history; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_history (
    facility_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    notify_id character varying(64) NOT NULL,
    last_notify timestamp without time zone NOT NULL
);


ALTER TABLE public.cc_notify_history OWNER TO hinemos;

--
-- Name: cc_notify_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_info (
    notify_id character varying(64) NOT NULL,
    description character varying(256),
    notify_type smallint NOT NULL,
    initial_count smallint NOT NULL,
    renotify_type smallint NOT NULL,
    renotify_period smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64),
    valid_flg smallint
);


ALTER TABLE public.cc_notify_info OWNER TO hinemos;

--
-- Name: cc_notify_job_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_job_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    job_run smallint NOT NULL,
    jobunit_id character varying(64),
    job_id character varying(64),
    job_failure_priority smallint,
    job_exec_facility_flg smallint,
    job_exec_facility character varying(64)
);


ALTER TABLE public.cc_notify_job_info OWNER TO hinemos;

--
-- Name: cc_notify_log_escalate_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_log_escalate_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    escalate_flg smallint NOT NULL,
    escalate_message character varying(1024),
    syslog_priority smallint,
    syslog_facility smallint,
    escalate_facility_flg smallint,
    escalate_facility character varying(64),
    escalate_port integer
);


ALTER TABLE public.cc_notify_log_escalate_info OWNER TO hinemos;

--
-- Name: cc_notify_mail_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_mail_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    mail_template_id character varying(64),
    mail_flg smallint NOT NULL,
    mail_address character varying(1024)
);


ALTER TABLE public.cc_notify_mail_info OWNER TO hinemos;

--
-- Name: cc_notify_relation_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_relation_info (
    notify_group_id character varying(1024) NOT NULL,
    notify_id character varying(64) NOT NULL,
    notify_type smallint,
    notify_flg smallint
);


ALTER TABLE public.cc_notify_relation_info OWNER TO hinemos;

--
-- Name: cc_notify_status_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_status_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    status_flg smallint NOT NULL,
    status_valid_period smallint,
    status_invalid_flg smallint,
    status_update_priority smallint
);


ALTER TABLE public.cc_notify_status_info OWNER TO hinemos;

--
-- Name: cc_notify_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_notify_type_mst (
    notify_type smallint NOT NULL,
    notify_name_key character varying(256) NOT NULL,
    queue_name character varying(64) NOT NULL,
    use_jms smallint,
    use_jta smallint,
    action_class_name character varying(256),
    dialog_class_name character varying(256)
);


ALTER TABLE public.cc_notify_type_mst OWNER TO hinemos;

--
-- Name: cc_priority_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_priority_info (
    judgment_id character varying(64) NOT NULL,
    description character varying(256),
    pattern_01 smallint,
    pattern_02 smallint,
    pattern_03 smallint,
    pattern_04 smallint,
    pattern_05 smallint,
    pattern_06 smallint,
    pattern_07 smallint,
    pattern_08 smallint,
    pattern_09 smallint,
    pattern_10 smallint,
    pattern_11 smallint,
    pattern_12 smallint,
    pattern_13 smallint,
    pattern_14 smallint,
    pattern_15 smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_priority_info OWNER TO hinemos;

--
-- Name: cc_snmp_trap_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_info (
    monitor_id character varying(64) NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    community_name character varying(64),
    notify_group_id character varying(1024),
    application character varying(64),
    valid_flg smallint NOT NULL,
    calendar_id character varying(64),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64),
    check_mode smallint
);


ALTER TABLE public.cc_snmp_trap_info OWNER TO hinemos;

--
-- Name: cc_snmp_trap_mib_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_mib_mst (
    mib character varying(64) NOT NULL,
    order_no smallint,
    description character varying(256),
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_snmp_trap_mib_mst OWNER TO hinemos;

--
-- Name: cc_snmp_trap_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_mst (
    mib character varying(1024) NOT NULL,
    trap_oid character varying(1024) NOT NULL,
    generic_id smallint NOT NULL,
    specific_id integer NOT NULL,
    uei text,
    logmsg text,
    descr text,
    priority smallint
);


ALTER TABLE public.cc_snmp_trap_mst OWNER TO hinemos;

--
-- Name: cc_snmp_trap_notify_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_notify_info (
    monitor_id character varying(64) NOT NULL,
    notify_id character varying(64) NOT NULL,
    notify_type smallint,
    notify_flg smallint
);


ALTER TABLE public.cc_snmp_trap_notify_info OWNER TO hinemos;

--
-- Name: cc_snmp_trap_oid_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_trap_oid_info (
    monitor_id character varying(64) NOT NULL,
    mib character varying(1024) NOT NULL,
    trap_oid character varying(1024) NOT NULL,
    generic_id smallint NOT NULL,
    specific_id integer NOT NULL,
    valid_flg smallint,
    priority smallint,
    logmsg text,
    descr text
);


ALTER TABLE public.cc_snmp_trap_oid_info OWNER TO hinemos;

--
-- Name: cc_snmp_value_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_snmp_value_type_mst (
    value_type character varying(64) NOT NULL
);


ALTER TABLE public.cc_snmp_value_type_mst OWNER TO hinemos;

--
-- Name: cc_status_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_status_info (
    facility_id character varying(64) NOT NULL,
    monitor_id character varying(64) NOT NULL,
    plugin_id character varying(64) NOT NULL,
    application character varying(64) NOT NULL,
    message_id character varying(64) NOT NULL,
    message character varying(256) NOT NULL,
    priority smallint NOT NULL,
    generation_date timestamp without time zone NOT NULL,
    output_date timestamp without time zone NOT NULL,
    expiration_flg smallint,
    expiration_date timestamp without time zone
);


ALTER TABLE public.cc_status_info OWNER TO hinemos;

--
-- Name: cc_syslog_monitor_rule; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_syslog_monitor_rule (
    order_no smallint NOT NULL,
    description character varying(256),
    facility_id character varying(64),
    pattern character varying(1024),
    process_type smallint NOT NULL,
    priority smallint NOT NULL,
    monitor_id character varying(64),
    application character varying(64),
    message_id character varying(64),
    message character varying(256),
    notify_group_id character varying(1024),
    calendar_id character varying(64),
    valid_flg smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(64),
    update_user character varying(64)
);


ALTER TABLE public.cc_syslog_monitor_rule OWNER TO hinemos;

--
-- Name: cc_system_notify_event_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_system_notify_event_info (
    notify_id character varying(64) NOT NULL,
    priority smallint NOT NULL,
    event_normal_flg smallint NOT NULL,
    event_normal_state smallint NOT NULL,
    event_inhibition_flg smallint NOT NULL,
    event_inhibition_state smallint,
    mail_flg smallint NOT NULL,
    mail_address character varying(1024)
);


ALTER TABLE public.cc_system_notify_event_info OWNER TO hinemos;

--
-- Name: cc_system_notify_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_system_notify_info (
    notify_id character varying(64) NOT NULL,
    description character varying(256),
    status_flg smallint NOT NULL,
    status_valid_period smallint,
    status_invalid_flg smallint,
    status_update_priority smallint,
    event_flg smallint NOT NULL,
    inhibition_flg smallint NOT NULL,
    inhibition_frequency smallint,
    inhibition_period smallint,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    mail_template_id character varying(64)
);


ALTER TABLE public.cc_system_notify_info OWNER TO hinemos;

--
-- Name: cc_vm_method_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_vm_method_mst (
    vm_solution_id character varying(64) NOT NULL,
    proc_type character varying(64) NOT NULL,
    class_name character varying(256) NOT NULL
);


ALTER TABLE public.cc_vm_method_mst OWNER TO hinemos;

--
-- Name: cc_vm_operation_detail; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_vm_operation_detail (
    session_id character varying(64) NOT NULL,
    facility_id character varying(64) NOT NULL,
    management_id character varying(64) NOT NULL,
    scope_text character varying(256),
    node_type character varying(64),
    command_id character varying(64),
    status smallint,
    start_date timestamp without time zone,
    end_status smallint,
    end_date timestamp without time zone,
    end_value integer,
    message text
);


ALTER TABLE public.cc_vm_operation_detail OWNER TO hinemos;

--
-- Name: cc_vm_protocol_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_vm_protocol_mst (
    vm_solution_id character varying(64) NOT NULL,
    protocol character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.cc_vm_protocol_mst OWNER TO hinemos;

--
-- Name: cc_vm_solution_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE cc_vm_solution_mst (
    vm_solution_id character varying(64) NOT NULL,
    order_no smallint NOT NULL,
    platform_id character varying(64) NOT NULL,
    vm_solution_name character varying(256) NOT NULL
);


ALTER TABLE public.cc_vm_solution_mst OWNER TO hinemos;

--
-- Name: hilosequences; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE hilosequences (
    sequencename character varying(50) NOT NULL,
    highvalues integer NOT NULL
);


ALTER TABLE public.hilosequences OWNER TO hinemos;

--
-- Name: jbm_counter; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_counter (
    name character varying(255) NOT NULL,
    next_id bigint
);


ALTER TABLE public.jbm_counter OWNER TO hinemos;

--
-- Name: jbm_dual; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_dual (
    dummy integer NOT NULL
);


ALTER TABLE public.jbm_dual OWNER TO hinemos;

--
-- Name: jbm_id_cache; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_id_cache (
    node_id integer NOT NULL,
    cntr integer NOT NULL,
    jbm_id character varying(255)
);


ALTER TABLE public.jbm_id_cache OWNER TO hinemos;

--
-- Name: jbm_msg; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_msg (
    message_id bigint NOT NULL,
    reliable character(1),
    expiration bigint,
    "timestamp" bigint,
    priority smallint,
    type smallint,
    headers bytea,
    payload bytea
);


ALTER TABLE public.jbm_msg OWNER TO hinemos;

--
-- Name: jbm_msg_ref; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_msg_ref (
    message_id bigint NOT NULL,
    channel_id bigint NOT NULL,
    transaction_id bigint,
    state character(1),
    ord bigint,
    page_ord bigint,
    delivery_count integer,
    sched_delivery bigint
);


ALTER TABLE public.jbm_msg_ref OWNER TO hinemos;

--
-- Name: jbm_postoffice; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_postoffice (
    postoffice_name character varying(255) NOT NULL,
    node_id integer NOT NULL,
    queue_name character varying(255) NOT NULL,
    cond character varying(1023),
    selector character varying(1023),
    channel_id bigint,
    clustered character(1),
    all_nodes character(1)
);


ALTER TABLE public.jbm_postoffice OWNER TO hinemos;

--
-- Name: jbm_role; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_role (
    role_id character varying(32) NOT NULL,
    user_id character varying(32) NOT NULL
);


ALTER TABLE public.jbm_role OWNER TO hinemos;

--
-- Name: jbm_tx; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_tx (
    node_id integer,
    transaction_id bigint NOT NULL,
    branch_qual bytea,
    format_id integer,
    global_txid bytea
);


ALTER TABLE public.jbm_tx OWNER TO hinemos;

--
-- Name: jbm_user; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jbm_user (
    user_id character varying(32) NOT NULL,
    passwd character varying(32) NOT NULL,
    clientid character varying(128)
);


ALTER TABLE public.jbm_user OWNER TO hinemos;

--
-- Name: jms_message_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jms_message_log (
    messageid integer NOT NULL,
    destination character varying(255) NOT NULL,
    txid integer,
    txop character(1),
    lateclone character(1),
    messageblob bytea
);


ALTER TABLE public.jms_message_log OWNER TO hinemos;

--
-- Name: jms_reference_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jms_reference_log (
    messageid integer NOT NULL,
    destination character varying(256) NOT NULL,
    txid integer,
    txop character(1),
    redelivered character(1),
    redelivers integer
);


ALTER TABLE public.jms_reference_log OWNER TO hinemos;

--
-- Name: jms_transaction_log; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE jms_transaction_log (
    txid integer
);


ALTER TABLE public.jms_transaction_log OWNER TO hinemos;

--
-- Name: maintenance_info; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE maintenance_info (
    maintenance_id character varying(64) NOT NULL,
    description character varying(256),
    type_id character varying(64) NOT NULL,
    keep_id character varying(64),
    calendar_id character varying(64),
    schedule_date timestamp without time zone,
    notify_group_id character varying(1024),
    application character varying(64),
    valid_flg smallint NOT NULL,
    reg_date timestamp without time zone,
    update_date timestamp without time zone,
    reg_user character varying(256),
    update_user character varying(256)
);


ALTER TABLE public.maintenance_info OWNER TO hinemos;

--
-- Name: maintenance_keep_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE maintenance_keep_mst (
    keep_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.maintenance_keep_mst OWNER TO hinemos;

--
-- Name: maintenance_type_mst; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE maintenance_type_mst (
    type_id character varying(64) NOT NULL,
    name_id character varying(256) NOT NULL,
    order_no smallint NOT NULL
);


ALTER TABLE public.maintenance_type_mst OWNER TO hinemos;

--
-- Name: qrtz_blob_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_blob_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    blob_data bytea
);


ALTER TABLE public.qrtz_blob_triggers OWNER TO hinemos;

--
-- Name: qrtz_calendars; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_calendars (
    calendar_name character varying(80) NOT NULL,
    calendar bytea NOT NULL
);


ALTER TABLE public.qrtz_calendars OWNER TO hinemos;

--
-- Name: qrtz_cron_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_cron_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    cron_expression character varying(80) NOT NULL,
    time_zone_id character varying(80)
);


ALTER TABLE public.qrtz_cron_triggers OWNER TO hinemos;

--
-- Name: qrtz_fired_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_fired_triggers (
    entry_id character varying(95) NOT NULL,
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    is_volatile boolean NOT NULL,
    instance_name character varying(80) NOT NULL,
    fired_time bigint NOT NULL,
    state character varying(16) NOT NULL,
    job_name character varying(80),
    job_group character varying(80),
    is_stateful boolean,
    requests_recovery boolean
);


ALTER TABLE public.qrtz_fired_triggers OWNER TO hinemos;

--
-- Name: qrtz_job_details; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_job_details (
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    description character varying(120),
    job_class_name character varying(128) NOT NULL,
    is_durable boolean NOT NULL,
    is_volatile boolean NOT NULL,
    is_stateful boolean NOT NULL,
    requests_recovery boolean NOT NULL,
    job_data bytea
);


ALTER TABLE public.qrtz_job_details OWNER TO hinemos;

--
-- Name: qrtz_job_listeners; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_job_listeners (
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    job_listener character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_job_listeners OWNER TO hinemos;

--
-- Name: qrtz_locks; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_locks (
    lock_name character varying(40) NOT NULL
);


ALTER TABLE public.qrtz_locks OWNER TO hinemos;

--
-- Name: qrtz_paused_trigger_grps; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_paused_trigger_grps (
    trigger_group character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_paused_trigger_grps OWNER TO hinemos;

--
-- Name: qrtz_scheduler_state; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_scheduler_state (
    instance_name character varying(80) NOT NULL,
    last_checkin_time bigint NOT NULL,
    checkin_interval bigint NOT NULL,
    recoverer character varying(80)
);


ALTER TABLE public.qrtz_scheduler_state OWNER TO hinemos;

--
-- Name: qrtz_simple_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_simple_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    repeat_count bigint NOT NULL,
    repeat_interval bigint NOT NULL,
    times_triggered bigint NOT NULL
);


ALTER TABLE public.qrtz_simple_triggers OWNER TO hinemos;

--
-- Name: qrtz_trigger_listeners; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_trigger_listeners (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    trigger_listener character varying(80) NOT NULL
);


ALTER TABLE public.qrtz_trigger_listeners OWNER TO hinemos;

--
-- Name: qrtz_triggers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE qrtz_triggers (
    trigger_name character varying(80) NOT NULL,
    trigger_group character varying(80) NOT NULL,
    job_name character varying(80) NOT NULL,
    job_group character varying(80) NOT NULL,
    is_volatile boolean NOT NULL,
    description character varying(120),
    next_fire_time bigint,
    prev_fire_time bigint,
    trigger_state character varying(16) NOT NULL,
    trigger_type character varying(8) NOT NULL,
    start_time bigint NOT NULL,
    end_time bigint,
    calendar_name character varying(80),
    misfire_instr smallint
);


ALTER TABLE public.qrtz_triggers OWNER TO hinemos;

--
-- Name: timers; Type: TABLE; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE TABLE timers (
    timerid character varying(80) NOT NULL,
    targetid character varying(250) NOT NULL,
    initialdate timestamp without time zone NOT NULL,
    timerinterval bigint,
    instancepk bytea,
    info bytea
);


ALTER TABLE public.timers OWNER TO hinemos;


--
-- Name: public; Type: ACL; Schema: -; Owner: hinemos
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM hinemos;
GRANT ALL ON SCHEMA public TO hinemos;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

