#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
FTP_PROC="/usr/kerberos/bin/ftp"
FTP_HOST=%%FTP_HOST%%
FTP_USER="hinemos"
FTP_PASSWD="hinemos"
EXPECT_PROC="/usr/bin/expect"
CHOWN_PROC="/bin/chown"
CHMOD_PROC="/bin/chmod"

##
## 引数格納
##
while [ $# -gt 0 ]
do
  #echo $1
  case $1 in
    -u)
      shift
      user="$1"
      ;;
    -g)
      shift
      group="$1"
      ;;
    -m)
      shift
      mode="$1"
      ;;
    -d)
      shift
      distdir="$1"
      ;;
    *)
      #ファイル名
      file=${1##/*/}
      #ファイルリモートパス
      remotepath=${1%/*}
      ;;
  esac

  shift

done


##
## ファイルをサーバからローカルに転送
##
$EXPECT_PROC -c "
    set timeout 300
    spawn $FTP_PROC $FTP_HOST
    expect Name*:
    send $FTP_USER\r
    expect Password:
    send $FTP_PASSWD\r
    expect {
	successful.	{}
	failed.		{exit 1}
	timeout		{exit 1}
    }
    expect >
    send \"lcd $distdir\r\"
    expect {
	No*such*file*or*directory	{exit 1}
	Permission*denied	{exit 1}
        >	{}
	timeout		{exit 1}
    }
    send \"cd $remotepath\r\"
    expect >
    send \"get $file\r\"
    expect {
	OK.		{}	
	Failed		{exit 1}
	timeout		{exit 1}
    }
    expect >
    send quit\r
    expect eof
"
if [ $? -ne 0 ] ; then
    echo 'File transfer error' 1>&2
    exit 10
fi

##
## chownコマンド実行
##
if [ ${#user} -ne 0 ] ; then
    ownarg=$user
fi
if [ ${#group} -ne 0 ] ; then
    ownarg=$ownarg:$group
fi
if [ ${#ownarg} -ne 0 ] ; then
    echo "$CHOWN_PROC $ownarg $distdir/$file"
    $CHOWN_PROC $ownarg $distdir/$file
    if [ $? -ne 0 ] ; then
        exit 1
    fi
fi

##
## chmodコマンド実行
##
if [ ${#mode} -ne 0 ] ; then
    echo "$CHMOD_PROC $mode $distdir/$file"
    $CHMOD_PROC $mode $distdir/$file
    if [ $? -ne 0 ] ; then
        exit 2
    fi
fi

exit
