#!/bin/sh

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration

GREP_PROC="/bin/grep"
EXPECT_PROC="/usr/bin/expect"
SSH_PROC="/usr/bin/ssh"
SCP_PROC="/usr/bin/scp"
TAR_PROC="/bin/tar"
AWK_PROC="/bin/awk"
PWD_PROC="/bin/pwd"
LS_PROC="/bin/ls"
RM_PROC="/bin/rm -rf"


HINEMOS_VERSION=%%HINEMOS_VERSION%%

AGENT_HOME="/opt/hinemos_agent"
AGENT_INSTALL_SH="agent_installer_JP.sh"

# Check on version
VERSION=`rpm -q --qf "%{VERSION}" redhat-release`
if [ $? -ne 0 ]; then
    echo "The redhat-release package is not installed. Please install the redhat-release package."
    exit -1
fi
echo ${VERSION} | grep 4 > /dev/null && VERSION="rhel4"
echo ${VERSION} | grep 5 > /dev/null && VERSION="rhel5"

# Check on architecture
ARCH=`rpm -q --qf "%{ARCH}" kernel`
if [ $? -ne 0 ]; then
    echo "The kernel package is not installed. Please install the kernel package."
    exit -1
fi
echo ${ARCH} | grep 64 > /dev/null  && VERSION=${VERSION}"_64"
if [ $? -ne 0 ]; then
	VERSION=${VERSION}"_32"
fi

# Name resolution of Hinemos agent package
AGENT_DIR="Hinemos_Agent-${HINEMOS_VERSION}_${VERSION}"
AGENT_PACKAGE="hinemos_agent-${HINEMOS_VERSION}_${VERSION}.tar.gz"
echo "インストール対象のパッケージは${AGENT_PACKAGE}です。"

# Variable
scp_address=""
mgr_address=""
pass=""
jre_ans=""
place=""

##
## Argument settings
##
while [ $# -gt 0 ] 
do
  case $1 in
    -a)
      shift
      agent=$1
      ;;
    -i)
      shift
      scp_address=$1
      ;;
    -p)
      shift
      pass=$1 
      ;;
    -j)
      shift
      jre_ans=$1
      ;;
    -m)
      shift
      mgr_address=$1
      ;;
    -w)
      shift
      ${LS_PROC} $1 > /dev/null
      if [ "$?" != 0 ];then
          echo "コピー先が存在しません。"
          exit -1
      fi
      place=$1
      ;;
    *)
      ;;
  esac

  shift 

done


##
## Confirmation
##

# 入力値の確認
if [ "${scp_address}" = "" ]; then
    echo "Hinemosエージェントインストーラが置いてあるサーバのIPアドレスを入力して下さい。"
    exit -1
elif [ "${pass}" = "" ]; then
    echo "Hinemosエージェントインストーラが置いてあるサーバのrootユーザのパスワードを入力して下さい。"
    exit -1
elif [ "${agent}" = "" ]; then
    echo "Hinemosエージェントインストーラのパスを入力して下さい。"
    exit -1
elif [ "${place}" = "" ]; then
    echo "エージェントインストーラをコピーする先を入力して下さい。"
    exit -1
elif [ "${mgr_address}" = "" ]; then
	echo "マネージャのIPアドレスを入力してください。"
	exit -1 
fi


## エージェントインストール配布マシンの設定確認
##
# IPアドレスの確認とパスワードの確認
$EXPECT_PROC -c "
    set timeout 10
    spawn -noecho $SSH_PROC -n ${scp_address} -l root \"
        ${LS_PROC} ${agent}/${AEGNT_PACKEGE}
    \"
    expect {
        -re \".*Name or service not known\" { exit 1}
        \"Are you sure\" { send yes\r }
        timeout
    }
    expect root
    send ${pass}\r
    expect {
        -re \".*${agent}/${AGENT_PACKAGE}\" { exit 0 }
        -re \".*${LS_PROC}\" { exit 3 }
        timeout { exit 2 }
    }
" > /dev/null
case $? in
    1)
      echo "IP:${scp_address}  IPアドレスが存在しません。"
      exit 1
      ;;
    2)
      echo "IP:${scp_address}  rootユーザのパスワードが間違っています。"
      exit 2
      ;;
    3)
      echo "${agent}/${AGENT_PACKAGE}は存在しません。"
      exit 3
      ;;
    *)
      break
      ;;
esac


##
## Hinemosエージェントの処理
##

# Hinemosエージェントインストーラを入力されたIPアドレスのサーバからコピーする。
$EXPECT_PROC -c "
    set timeout -1
    spawn $SCP_PROC root@${scp_address}:${agent}/${AGENT_PACKAGE} ${place}
    expect root
    send ${pass}\r
    expect eof
" > /dev/null


if [ $? != 0 ];then
    echo "Hinemosエージェントインストーラのコピーに失敗しました。"
    exit 10
fi
echo "Hinemosエージェントインストーラのコピーに成功しました。"
echo "  ${place}/${AGENT_PACKAGE}"

# Hinemos:エージェントの解凍
CURRENT_PLACE=`${PWD_PROC}`
cd ${place}
${TAR_PROC} -zxf ${AGENT_PACKAGE} > /dev/null 2>&1
if [ $? != 0 ];then
    echo "Hinemosエージェントの解凍に失敗しました。"
    exit 1
fi
echo "Hinemosエージェントの解凍に成功しました。"
echo "  ${place}/${AGENT_DIR}"
echo "インストール終了後に削除してください。"
echo ""
echo "インストールを開始します。"

cd ${CURRENT_PLACE}

AGENT_LOG="${place}/${AGENT_DIR}/agent_install.log"

# Hinemosエージェントのインストール
$EXPECT_PROC -c "
    set timeout -1
    spawn ${place}/${AGENT_DIR}/${AGENT_INSTALL_SH}

#最初のメニュー選択で1を選択
    expect {
        -re \".*==>\" { send \"1\r\" }
        eof { exit 1 }
    }
#    send 1\r


#インストールを開始します。よろしいですか？(Y/N デフォルト:Y) : 
    expect -re \".*\?\(Y\/N.*\).*\"
    send Y\r

#インストールディレクトリは/opt/hinemos_agentでよろしいですか？ (Y/N デフォルト:Y) : 
    expect -re \".*\?\(Y\/N.*\).*\"
    send Y\r


#hostsファイルのチェック
    expect {
	-re \".*(Y.*\/ N.*\).*\" {send Y\r}
	-re \".*OK.*\" {}
	}

#rpmのチェック	

    expect {
	-re \".*\?\(Y\/N.*\).*\" {send Y\r}
	-re \".*OK.*\" {}
	}
	

#マネージャのIPアドレス設定
    expect -re \".*IP.*\"
    send ${mgr_address}\r
    expect -re \".*\(Y\/N.*\)\"
    send Y\r

#サービススクリプトを配置します。よろしいですか？ (Y/N デフォルト:Y) : 
    expect -re \".*\?\(Y\/N.*\).*\"
    send Y\r

#javaインストーラでのアクション
    expect -re \".*Do you agree to the above license terms.*\"
    send ${jre_ans}\r

#再度表示されるメニュー選択で9を選択 
    expect -re \".*==>\"
    send 9\r
    expect eof

" >${AGENT_LOG} 2>&1

echo ""

if [ $? = 0 ]; then
    echo "Hinemosエージェントのインストールが完了しました。 ${place}の${AGENT_DIR}/agent_install.log を確認して下さい。" 
else
    echo "Hinemosエージェントのインストールに失敗しました。 "
    echo "詳細は、${place}の${AGENT_DIR}/agent_install.log を確認して下さい。"
    exit -1
fi

exit
