#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../hinemos.cfg
. ${SCRIPT_DIR}/../sbin/hinemos_utility.sh

export PROG=`basename $0`
DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################


########################################
#  Local Message
########################################

# INFO
MSG_I001="${PROG}    : shutdown Hinemos Manager"
MSG_I002="waiting for Hinemos Manager to stop..."
MSG_I003="Hinemos Manager stopped"

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="usage : ${PROG} (no argument)"
MSG_E002="incorrect user(${USER}). please check variable HINEMOS_JBOSS_USER (${HINEMOS_HOME}/hinemos.cfg).";
MSG_E003="failed to stop Hinemos Manager"

########################################
# Function
########################################


########################################
# SHELL
########################################

#
# check argument
#
for ARGS in "$@"
do
	case ${ARGS} in
		*)
			Logging "${MSG_E001}"
			Logging "${MSG_I001}"
			exit -1
			;;
	esac
done

#
# check user executed
#
if [ "x"${USER} != "x"${HINEMOS_JBOSS_USER} ]
then
	Logging "${MSG_E002}"
	exit -2
fi

Logging "${MSG_I002}" && echo

# shutdown JBoss
${HINEMOS_HOME}/bin/jboss_stop.sh

RET=$?
if [ ${RET} -ne 0 ]
then
	echo && Logging "${MSG_E003}"
	exit ${RET}
fi

# shutdown PostgreSQL
if [ "x"${USER} = "x"${HINEMOS_PG_USER} ]
then
	${HINEMOS_HOME}/bin/pg_stop.sh
else
	su -c ${HINEMOS_HOME}/bin/pg_stop.sh - ${HINEMOS_PG_USER}
fi

RET=$?
if [ ${RET} -ne 0 ]
then
	echo && Logging "${MSG_E003}"
	exit ${RET}
fi

echo && Logging "${MSG_I003}"

exit 0
