/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee.statistics;

import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JVMStats;
import javax.management.j2ee.statistics.Statistic;
import org.jboss.management.j2ee.statistics.BoundedRangeStatisticImpl;
import org.jboss.management.j2ee.statistics.CountStatisticImpl;
import org.jboss.management.j2ee.statistics.StatsBase;

public class JVMStatsImpl
extends StatsBase
implements JVMStats {
    private static final long serialVersionUID = -7842397217562728796L;

    public JVMStatsImpl() {
        this(new CountStatisticImpl("UpTime", "MILLISECOND", "Time the VM has been running"), new BoundedRangeStatisticImpl("HeapSize", "Bytes", "Size of the VM's heap", 0L, 0L));
    }

    public JVMStatsImpl(CountStatistic upTime, BoundedRangeStatistic heapSize) {
        this.addStatistic("UpTime", (Statistic)upTime);
        this.addStatistic("HeapSize", (Statistic)heapSize);
    }

    public CountStatistic getUpTime() {
        CountStatisticImpl upTime = (CountStatisticImpl)this.getStatistic("UpTime");
        long now = System.currentTimeMillis();
        long elapsed = now - upTime.getStartTime();
        upTime.set(elapsed);
        return upTime;
    }

    public BoundedRangeStatistic getHeapSize() {
        BoundedRangeStatisticImpl heapSize = (BoundedRangeStatisticImpl)this.getStatistic("HeapSize");
        long totalMemory = Runtime.getRuntime().totalMemory();
        heapSize.set(totalMemory);
        return heapSize;
    }
}

