/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.TimeStatistic;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.JCAConnectionFactoryMBean;
import org.jboss.management.j2ee.JCAManagedConnectionFactory;
import org.jboss.management.j2ee.statistics.BoundedRangeStatisticImpl;
import org.jboss.management.j2ee.statistics.CountStatisticImpl;
import org.jboss.management.j2ee.statistics.JCAConnectionPoolStatsImpl;

public class JCAConnectionFactory
extends J2EEManagedObject
implements JCAConnectionFactoryMBean {
    private static Logger log = Logger.getLogger(JCAConnectionFactory.class);
    private ObjectName cmServiceName;
    private ObjectName mcfServiceName;
    private String jsr77MCFName;
    private JCAConnectionPoolStatsImpl poolStats;

    public static ObjectName create(MBeanServer mbeanServer, String resName, ObjectName jsr77ParentName, ObjectName ccmServiceNameName, ObjectName mcfServiceName) {
        ObjectName jsr77Name = null;
        try {
            JCAConnectionFactory jcaFactory = new JCAConnectionFactory(resName, jsr77ParentName, ccmServiceNameName, mcfServiceName);
            jsr77Name = jcaFactory.getObjectName();
            mbeanServer.registerMBean(jcaFactory, jsr77Name);
            log.debug((Object)("Created JSR-77 JCAConnectionFactory: " + resName));
            ObjectName jsr77MCFName = JCAManagedConnectionFactory.create(mbeanServer, resName, jsr77Name);
            jcaFactory.setmanagedConnectionFactory(jsr77MCFName.getCanonicalName());
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 JCAConnectionFactory: " + resName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, String resName) {
        try {
            String connName = J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JCAConnectionFactory" + ",name=" + resName + ",*";
            J2EEManagedObject.removeObject(mbeanServer, connName);
        }
        catch (InstanceNotFoundException infe) {
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 JCAConnectionFactory: " + resName), (Throwable)e);
        }
    }

    public JCAConnectionFactory(String resName, ObjectName jsr77ParentName, ObjectName ccmServiceNameName, ObjectName mcfServiceName) throws MalformedObjectNameException, InvalidParentException {
        super("JCAConnectionFactory", resName, jsr77ParentName);
        this.cmServiceName = ccmServiceNameName;
        this.mcfServiceName = mcfServiceName;
    }

    public String getmanagedConnectionFactory() {
        return this.jsr77MCFName;
    }

    void setmanagedConnectionFactory(String jsr77MCFName) {
        this.jsr77MCFName = jsr77MCFName;
    }

    public JCAConnectionPoolStatsImpl getPoolStats(ObjectName poolServiceName) {
        TimeStatistic waitTime = null;
        TimeStatistic useTime = null;
        CountStatisticImpl closeCount = null;
        CountStatisticImpl createCount = null;
        BoundedRangeStatisticImpl freePoolSize = null;
        BoundedRangeStatisticImpl poolSize = null;
        RangeStatistic waitingThreadCount = null;
        try {
            if (this.poolStats == null) {
                Integer max = (Integer)this.server.getAttribute(poolServiceName, "MaxSize");
                freePoolSize = new BoundedRangeStatisticImpl("FreePoolSize", "1", "The free connection count", 0L, max.longValue());
                poolSize = new BoundedRangeStatisticImpl("PoolSize", "1", "The connection count", 0L, max.longValue());
                this.poolStats = new JCAConnectionPoolStatsImpl(this.getobjectName(), this.jsr77MCFName, waitTime, useTime, closeCount, createCount, freePoolSize, poolSize, waitingThreadCount);
            }
            createCount = (CountStatisticImpl)this.poolStats.getCreateCount();
            closeCount = (CountStatisticImpl)this.poolStats.getCloseCount();
            freePoolSize = (BoundedRangeStatisticImpl)this.poolStats.getFreePoolSize();
            poolSize = (BoundedRangeStatisticImpl)this.poolStats.getPoolSize();
            Integer isize = (Integer)this.server.getAttribute(poolServiceName, "ConnectionCreatedCount");
            createCount.set(isize.longValue());
            isize = (Integer)this.server.getAttribute(poolServiceName, "ConnectionDestroyedCount");
            closeCount.set(isize.longValue());
            isize = (Integer)this.server.getAttribute(poolServiceName, "ConnectionCount");
            poolSize.set(isize.longValue());
            Long lsize = (Long)this.server.getAttribute(poolServiceName, "AvailableConnectionCount");
            freePoolSize.set(lsize);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to update JCAConnectionPoolStats", (Throwable)e);
        }
        return this.poolStats;
    }

    public String toString() {
        return "JCAConnectionFactory { " + super.toString() + " } [ " + " ]";
    }

    protected Hashtable getParentKeys(ObjectName parentName) {
        Hashtable<String, String> keys = new Hashtable<String, String>();
        Hashtable<String, String> nameProps = parentName.getKeyPropertyList();
        String factoryName = nameProps.get("name");
        String serverName = nameProps.get("J2EEServer");
        keys.put("J2EEServer", serverName);
        keys.put("JCAResource", factoryName);
        return keys;
    }
}

