/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ldap.Control;
import javax.naming.spi.ObjectFactory;
import org.jboss.naming.ExternalContextMBean;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.Classes;

public class ExternalContext
extends ServiceMBeanSupport
implements ExternalContextMBean {
    private boolean remoteAccess;
    private SerializableInitialContext contextInfo = new SerializableInitialContext();

    public ExternalContext() {
    }

    public ExternalContext(String jndiName, String contextPropsURL) throws IOException, NamingException {
        this.setJndiName(jndiName);
        this.setPropertiesURL(contextPropsURL);
    }

    public String getJndiName() {
        return this.contextInfo.getJndiName();
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.contextInfo.setJndiName(jndiName);
        if (super.getState() == 3) {
            this.unbind(jndiName);
            try {
                this.rebind();
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Failed to update jndiName");
                ne.setRootCause(e);
                throw ne;
            }
        }
    }

    public boolean getRemoteAccess() {
        return this.remoteAccess;
    }

    public void setRemoteAccess(boolean remoteAccess) {
        this.remoteAccess = remoteAccess;
    }

    public boolean getCacheContext() {
        return this.contextInfo.getCacheContext();
    }

    public void setCacheContext(boolean cacheContext) {
        this.contextInfo.setCacheContext(cacheContext);
    }

    public String getInitialContext() {
        return this.contextInfo.getInitialContext();
    }

    public void setInitialContext(String className) throws ClassNotFoundException {
        this.contextInfo.loadClass(className);
    }

    public void setPropertiesURL(String contextPropsURL) throws IOException {
        this.contextInfo.loadProperties(contextPropsURL);
    }

    public void setProperties(Properties props) throws IOException {
        this.contextInfo.setProperties(props);
    }

    public Properties getProperties() throws IOException {
        return this.contextInfo.getProperties();
    }

    protected void startService() throws Exception {
        this.rebind();
    }

    protected void stopService() throws Exception {
        if (this.contextInfo.getCacheContext()) {
            this.unbind(this.contextInfo.getJndiName());
        }
    }

    private static Context createContext(Context rootContext, Name name) throws NamingException {
        Context subctx = rootContext;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws Exception {
        Context ctx = this.contextInfo.newContext();
        InitialContext rootCtx = new InitialContext();
        this.log.debug((Object)("ctx=" + ctx + ", env=" + ctx.getEnvironment()));
        String jndiName = this.contextInfo.getJndiName();
        Name fullName = rootCtx.getNameParser("").parse(jndiName);
        this.log.debug((Object)("fullName=" + fullName));
        Name parentName = fullName;
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        this.log.debug((Object)("parentName=" + parentName));
        Context parentCtx = ExternalContext.createContext(rootCtx, parentName);
        this.log.debug((Object)("parentCtx=" + parentCtx));
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atom = atomName.get(0);
        boolean cacheContext = this.contextInfo.getCacheContext();
        if (this.remoteAccess) {
            parentCtx.rebind(atom, (Object)this.contextInfo);
            if (cacheContext) {
                ctx = CachedContext.createProxyContext(ctx);
                NonSerializableFactory.rebind((String)jndiName, (Object)ctx);
            }
        } else if (cacheContext) {
            Context proxyCtx = CachedContext.createProxyContext(ctx);
            NonSerializableFactory.rebind((Context)rootCtx, (String)jndiName, (Object)proxyCtx);
        } else {
            parentCtx.rebind(atom, (Object)this.contextInfo);
        }
    }

    private void unbind(String jndiName) {
        try {
            InitialContext rootCtx = new InitialContext();
            Context ctx = (Context)rootCtx.lookup(jndiName);
            if (ctx != null) {
                ctx.close();
            }
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)jndiName);
        }
        catch (NamingException e) {
            this.log.error((Object)"unbind failed", (Throwable)e);
        }
    }

    static class CachedContext
    implements InvocationHandler {
        Context externalCtx;

        CachedContext(Context externalCtx) {
            this.externalCtx = externalCtx;
        }

        static Context createProxyContext(Context ctx) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ArrayList ifaces = new ArrayList();
            Classes.getAllInterfaces(ifaces, ctx.getClass());
            Class[] interfaces = new Class[ifaces.size()];
            ifaces.toArray(interfaces);
            CachedContext handler = new CachedContext(ctx);
            Context proxyCtx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
            return proxyCtx;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = null;
            if (!method.getName().equals("close")) {
                try {
                    value = method.invoke((Object)this.externalCtx, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return value;
        }
    }

    public static class SerializableInitialContext
    extends RefAddr
    implements Referenceable,
    Serializable,
    ObjectFactory {
        private static final long serialVersionUID = -6512260531255770463L;
        private String jndiName;
        private Class contextClass = InitialContext.class;
        private Properties contextProps;
        private boolean cacheContext = true;
        private transient Context initialContext;

        public SerializableInitialContext() {
            this("SerializableInitialContext");
        }

        public SerializableInitialContext(String addrType) {
            super(addrType);
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String jndiName) {
            this.jndiName = jndiName;
        }

        public boolean getCacheContext() {
            return this.cacheContext;
        }

        public void setCacheContext(boolean cacheContext) {
            this.cacheContext = cacheContext;
        }

        public String getInitialContext() {
            return this.contextClass.getName();
        }

        public void loadClass(String className) throws ClassNotFoundException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this.contextClass = loader.loadClass(className);
        }

        public void setProperties(Properties props) {
            this.contextProps = props;
        }

        public Properties getProperties() {
            return this.contextProps;
        }

        public void loadProperties(String contextPropsURL) throws IOException {
            InputStream is = null;
            this.contextProps = new Properties();
            try {
                URL url = new URL(contextPropsURL);
                is = url.openStream();
                this.contextProps.load(is);
                return;
            }
            catch (IOException e) {
                is = null;
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(contextPropsURL);
                if (is == null) {
                    throw new IOException("Failed to locate context props as URL or resource:" + contextPropsURL);
                }
                this.contextProps.load(is);
                return;
            }
        }

        Context newContext() throws Exception {
            this.initialContext = (Context)NonSerializableFactory.lookup((String)this.jndiName);
            if (this.initialContext == null) {
                this.initialContext = SerializableInitialContext.newContext(this.contextClass, this.contextProps);
            }
            return this.initialContext;
        }

        static Context newContext(Class contextClass, Properties contextProps) throws Exception {
            Context ctx = null;
            try {
                ctx = SerializableInitialContext.newDefaultContext(contextClass, contextProps);
            }
            catch (NoSuchMethodException e) {
                ctx = SerializableInitialContext.newLdapContext(contextClass, contextProps);
            }
            return ctx;
        }

        private static Context newDefaultContext(Class contextClass, Properties contextProps) throws Exception {
            Context ctx = null;
            Class[] types = new Class[]{Hashtable.class};
            Constructor ctor = contextClass.getConstructor(types);
            Object[] args = new Object[]{contextProps};
            ctx = (Context)ctor.newInstance(args);
            return ctx;
        }

        private static Context newLdapContext(Class contextClass, Properties contextProps) throws Exception {
            Context ctx = null;
            Class[] types = new Class[]{Hashtable.class, Control[].class};
            Constructor ctor = contextClass.getConstructor(types);
            Object[] args = new Object[]{contextProps, null};
            ctx = (Context)ctor.newInstance(args);
            return ctx;
        }

        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            Reference ref = (Reference)obj;
            SerializableInitialContext sic = (SerializableInitialContext)ref.get(0);
            return sic.newContext();
        }

        public Reference getReference() throws NamingException {
            Reference ref = new Reference(Context.class.getName(), this, this.getClass().getName(), null);
            return ref;
        }

        public Object getContent() {
            return null;
        }
    }
}

