/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.lang.reflect.Method;
import java.sql.SQLException;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc2.CreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;

public class ApplicationPkCreateCommand
implements CreateCommand {
    private JDBCEntityBridge2 entityBridge;

    public void init(JDBCStoreManager2 manager) throws DeploymentException {
        this.entityBridge = (JDBCEntityBridge2)manager.getEntityBridge();
    }

    public Object execute(Method m, Object[] args, EntityEnterpriseContext ctx) throws CreateException {
        Object pk;
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        if (ctx.getId() == null) {
            pk = this.entityBridge.extractPrimaryKeyFromInstance(ctx);
            if (pk == null) {
                throw new CreateException("Primary key for created instance is null.");
            }
            pctx.setPk(pk);
        } else {
            try {
                pctx.flush();
            }
            catch (SQLException e) {
                if ("23000".equals(e.getSQLState())) {
                    throw new DuplicateKeyException("Unique key violation or invalid foreign key value: pk=" + ctx.getId());
                }
                throw new CreateException("Failed to create instance: pk=" + ctx.getId() + ", state=" + e.getSQLState() + ", msg=" + e.getMessage());
            }
            pk = ctx.getId();
        }
        return pk;
    }
}

