/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.debug.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bsf.debug.util.DebugLog;
import org.apache.bsf.debug.util.IntHashtable;
import org.apache.bsf.debug.util.ResultCell;
import org.apache.bsf.debug.util.Skeleton;
import org.apache.bsf.debug.util.Stub;
import org.apache.bsf.debug.util.StubTable;
import org.apache.bsf.debug.util.ThreadCell;

public abstract class SocketConnection {
    Vector m_rcells;
    Hashtable m_tcells;
    IntHashtable m_tcellsById;
    private boolean keep_listening;
    int fCmdIdGenerator;
    IntHashtable m_skeletons;
    protected StubTable fStubs = null;
    protected InputStream fInputStream;
    protected OutputStream fOutputStream;
    protected DataInputStream fDataInputStream;
    protected DataOutputStream fDataOutputStream;
    private boolean m_outStreamLocked = false;
    private Object m_outStreamLock = new Object();

    protected SocketConnection() {
        this.m_skeletons = new IntHashtable();
        this.m_rcells = new Vector();
        this.m_tcells = new Hashtable();
        this.m_tcellsById = new IntHashtable();
        this.fCmdIdGenerator = ThreadCell.isServer ? 10000 : 90000;
    }

    public void exportSkeleton(Skeleton skeleton) {
        skeleton.allocOid(this);
        this.m_skeletons.put(skeleton.getUid(), skeleton);
    }

    public Skeleton getSkeleton(int n) {
        return (Skeleton)this.m_skeletons.get(n);
    }

    public Stub getStub(int n, int n2) {
        return this.fStubs.swizzle(n, n2);
    }

    public void listen() {
        Object var1_1 = null;
        this.setListening(true);
        while (this.keep_listening) {
            try {
                byte[] byArray;
                int n = this.fDataInputStream.readInt();
                int n2 = this.fDataInputStream.readInt();
                boolean bl = this.fDataInputStream.readBoolean();
                int n3 = this.fDataInputStream.readInt();
                boolean bl2 = this.fDataInputStream.readBoolean();
                if (n != 0) {
                    byArray = new byte[n];
                    if (n != this.fInputStream.read(byArray)) {
                        throw new Error("Wire Protocol Error");
                    }
                } else {
                    byArray = new byte[]{};
                }
                if (bl) {
                    this.receivedException(n2, n3, byArray);
                    continue;
                }
                if (bl2) {
                    this.receivedResult(n2, n3, byArray);
                    continue;
                }
                this.receivedInvocation(n2, n3, byArray);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Exception exception) {
                this.wireExceptionNotify(exception);
            }
        }
    }

    public void stopListening() {
        Enumeration enumeration = this.m_rcells.elements();
        while (enumeration.hasMoreElements()) {
            ResultCell resultCell = (ResultCell)enumeration.nextElement();
            try {
                resultCell.disconnected = true;
                resultCell.completionNotify();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.fStubs.disconnectNotify();
        this.setListening(false);
    }

    private synchronized void setListening(boolean bl) {
        this.keep_listening = bl;
    }

    private void receivedException(int n, int n2, byte[] byArray) throws IOException {
        if (ThreadCell.isServer) {
            DebugLog.stdoutPrintln("Received error from CLIENT...", 2);
        } else {
            DebugLog.stdoutPrintln("Received error from SERVER...", 2);
        }
        DebugLog.stdoutPrintln("\t**** ERROR: thId=" + n + ", cmdId=" + n2, 2);
        ResultCell resultCell = this.searchCell(n2);
        resultCell.setPacketBytes(byArray);
        resultCell.readException();
        resultCell.print();
        resultCell.thread.completionNotify(resultCell);
    }

    private void receivedResult(int n, int n2, byte[] byArray) {
        DebugLog.stdoutPrintln("\t<<<< RESULT: thId=" + n + ", cmdId=" + n2, 3);
        if (byArray != null) {
            DebugLog.stdoutPrintln("\t\tbyte count=" + byArray.length, 3);
        } else {
            DebugLog.stdoutPrintln("\t\tno bytes", 3);
        }
        ResultCell resultCell = this.searchCell(n2);
        resultCell.setPacketBytes(byArray);
        resultCell.parseResult();
        resultCell.completionNotify();
    }

    private synchronized void receivedInvocation(int n, int n2, byte[] byArray) throws Exception {
        DebugLog.stdoutPrintln("\t>>>> INVOCATION: thId=" + n + ", cmdId=" + n2, 3);
        if (byArray != null) {
            DebugLog.stdoutPrintln("\t\tbyte count=" + byArray.length, 3);
        } else {
            DebugLog.stdoutPrintln("\t\tno bytes", 3);
        }
        ResultCell resultCell = new ResultCell(this);
        this.m_rcells.addElement(resultCell);
        resultCell.incomingInvocation(n2, byArray);
        this.invoke(resultCell, n);
    }

    void completionNotify(ResultCell resultCell) {
        try {
            resultCell.sendResult();
        }
        catch (Exception exception) {
            DebugLog.stdoutPrintln("Exception Raised while sending result.", 0);
            exception.printStackTrace();
        }
    }

    private void invoke(ResultCell resultCell, int n) {
        ThreadCell threadCell = (ThreadCell)this.m_tcellsById.get(n);
        if (threadCell == null) {
            threadCell = new ThreadCell(this, n);
            Thread thread = threadCell.getThread();
            this.m_tcells.put(thread, threadCell);
            this.m_tcellsById.put(n, threadCell);
        }
        threadCell.pushLoopback(resultCell);
    }

    public synchronized ResultCell prepareOutgoingInvoke(Stub stub, int n, int n2) throws IOException {
        Thread thread = Thread.currentThread();
        ThreadCell threadCell = (ThreadCell)this.m_tcells.get(thread);
        if (threadCell == null) {
            threadCell = new ThreadCell(this, thread);
            this.m_tcells.put(thread, threadCell);
            this.m_tcellsById.put(threadCell.getThId(), threadCell);
        }
        ResultCell resultCell = new ResultCell(this);
        int n3 = ThreadCell.isServer ? ++this.fCmdIdGenerator : --this.fCmdIdGenerator;
        resultCell.outgoingInvocation(n3, n, n2, stub);
        this.m_rcells.addElement(resultCell);
        threadCell.pushInvocation(resultCell);
        return resultCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockOutStream() {
        Object object = this.m_outStreamLock;
        synchronized (object) {
            while (this.m_outStreamLocked) {
                try {
                    this.m_outStreamLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_outStreamLocked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseOutStream() {
        Object object = this.m_outStreamLock;
        synchronized (object) {
            this.m_outStreamLocked = false;
            this.m_outStreamLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(int n, int n2, boolean bl, byte[] byArray, boolean bl2) {
        try {
            DataOutputStream dataOutputStream = this.fDataOutputStream;
            synchronized (dataOutputStream) {
                this.fDataOutputStream.writeInt(byArray.length);
                this.fDataOutputStream.writeInt(n);
                this.fDataOutputStream.writeBoolean(bl2);
                this.fDataOutputStream.writeInt(n2);
                this.fDataOutputStream.writeBoolean(bl);
                if (byArray.length != 0) {
                    this.fOutputStream.write(byArray);
                }
            }
        }
        catch (Exception exception) {
            DebugLog.stdoutPrintln("Exception during sending result...", 0);
            exception.printStackTrace();
            this.wireExceptionNotify(exception);
        }
    }

    public synchronized ResultCell searchCell(int n) {
        ResultCell resultCell = null;
        Enumeration enumeration = this.m_rcells.elements();
        while (enumeration.hasMoreElements()) {
            resultCell = (ResultCell)enumeration.nextElement();
            if (resultCell.cmdId == n) break;
            resultCell = null;
        }
        if (resultCell == null) {
            throw new Error("Error in Wire Protocol, can't find CmdId=" + n);
        }
        return resultCell;
    }

    public Stub swizzle(int n, int n2) {
        return this.fStubs.swizzle(n, n2);
    }

    protected abstract void dispatchInvocation(ResultCell var1) throws Exception;

    protected void wireExceptionNotify(Exception exception) {
        DebugLog.stdoutPrintln("A WIRE exception occurred.", 2);
        DebugLog.stdoutPrintln(exception.toString(), 2);
        this.disconnectNotify(exception);
        this.fStubs.disconnectNotify();
        this.setListening(false);
    }

    private synchronized void disconnectNotify(Exception exception) {
        DebugLog.stdoutPrintln("Raise the exception in all waiting threads...", 2);
        Enumeration enumeration = this.m_rcells.elements();
        while (enumeration.hasMoreElements()) {
            ResultCell resultCell = (ResultCell)enumeration.nextElement();
            try {
                resultCell.setException(exception);
                resultCell.disconnected = true;
                resultCell.completionNotify();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.m_rcells = new Vector();
        this.m_tcells = new Hashtable();
        DebugLog.stdoutPrintln("Done with raising exceptions...", 2);
    }
}

