/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.integrity;

import java.util.Set;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.integrity.AbstractTransactionIntegrity;

public class FailIncompleteTransactionIntegrity
extends AbstractTransactionIntegrity {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTransactionIntegrity(TransactionImpl transaction) {
        Set threads = transaction.getAssociatedThreads();
        String rollbackError = null;
        Set set = threads;
        synchronized (set) {
            if (threads.size() > 1) {
                rollbackError = "Too many threads " + threads + " associated with transaction " + transaction;
            } else if (threads.size() != 0) {
                Thread other = (Thread)threads.iterator().next();
                Thread current = Thread.currentThread();
                if (!current.equals(other)) {
                    rollbackError = "Attempt to commit transaction " + transaction + " on thread " + current + " with other threads still associated with the transaction " + other;
                }
            }
        }
        if (rollbackError != null) {
            this.log.error((Object)rollbackError, (Throwable)new IllegalStateException("STACKTRACE"));
            this.markRollback(transaction);
        }
    }
}

