#!/bin/sh

#Copyright (C) since 2006 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details
 

#ユーザチェック
if [ !  `whoami` = root ]; then
    echo "rootユーザで実行してください。"
    exit
fi

#設定情報読み込み
. ${0%/*}/install.cfg


SYSLOGNG_FLG=0

##
## syslog-ngのアンインストール
##
syslogng_uninstall() {
	while [ 1 ] ;
	do
		echo ""
		echo "syslog-ngをアンインストールします。よろしいですか?(Y/N)"
		read ANS_SYS
		case ${ANS_SYS} in
			y|Y)
  				#syslog-ngアンインストール
				/etc/init.d/syslog-ng stop
				/etc/init.d/syslog start
    			/sbin/chkconfig --level 2345 syslog-ng off
				/sbin/chkconfig --level 2345 syslog on
				rpm -e syslog-ng libevtlog0
				echo "syslog-ngをアンインストールしました。"
				echo ""
				echo "syslog-ng.confのバックアップファイルが作成されました。"
				echo "	/etc/syslog-ng/syslog-ng.conf.rpmsave"	
				echo "アンインストール完了後、確認してください。"
				break
				;;
			n|N)
				echo "syslog-ngをアンインストールしませんでした。"
				echo "設定を変更する場合は、インストールマニュアルを参照ください。"
				break
				;;
			*)
				;;
		esac
	done
}


##
## hinemosユーザの削除
##
user_uninstall() {
	while [ 1 ] ;
	do
		echo ""
		echo "ユーザ ${HINEMOS_USER}を削除します。(ユーザ ${HINEMOS_USER}のホームディレクトリも削除します。)"
		echo "よろしいですか?(Y/N)"
		read ANS_USER
		case ${ANS_USER} in
 			y|Y)
 				id ${HINEMOS_USER} > /dev/null 2>&1
 				if [ "${?}" = "0" ] ; then
					userdel -r ${HINEMOS_USER}
					echo "ユーザ ${HINEMOS_USER}を削除しました。"
				else
					echo "ユーザ ${HINEMOS_USER}は存在しません。"
				fi
				break
				;;
			n|N)
				echo "ユーザ ${HINEMOS_USER}を削除しませんでした。"
				break
				;;
 			*)
				;;
		esac
	done
}

##
## アンインストーラ本編
##
while [ 1 ] ;
do
	echo "Hinemosをアンインストールします。よろしいですか?(Y/N)"
	read ANS
	case ${ANS} in
		y|Y)
	  		#プロセス終了確認
  	  		ps axu | grep postgres | grep -v grep | grep hinemos > /dev/null
	  		RET1=$?  

	  		ps axu | grep slapd | grep -v grep | grep hinemos > /dev/null 
	  		RET2=$?  

	  		ps axu | grep run_hinemos.sh | grep -v grep | grep hinemos |grep java > /dev/null 
	  		RET3=$? 

	  		if [ ${RET1} -eq 0 -o ${RET2} -eq 0 -o ${RET3} -eq 0 ]; then
				echo "Hinemosが起動中です。Hinemosを停止してからアンインストールを実行してください。"
				echo "Hinemosのアンインストールを中止します。"
				exit 1
	  		fi

			# syslog-ngのアンインストール
			rpm -q syslog-ng > /dev/null
			if [ "${?}" = "0" ] ; then
				syslogng_uninstall
			fi

			# hinemosユーザの削除
			user_uninstall
		
			#Hinemosマネージャファイルの削除
			echo ""
			echo "${HINEMOS_HOME}を削除します。"
			if [ -d ${HINEMOS_HOME} ] ; then
				rm -fr ${HINEMOS_HOME}
				echo "${HINEMOS_HOME}を削除しました。"
			else
				echo "${HINEMOS_HOME}は存在しません。"
			fi

			#残存する設定の表示
			echo ""
			echo "以下の設定については、hinemos以外でも使用されている可能性があるため変更しません。"
			echo "	・/etc/hostsファイルの設定"
			echo "	・カーネルメモリ(SHMMAX,SHMALL)の設定"
			echo "詳細については、インストールマニュアルを参照ください。"

			sleep 2

			echo ""
			echo "アンインストールが完了しました。"
			break
	  		;;
		*)
	  		echo "Hinemosのアンインストールを中止しました。"
			break
	  		;;
	esac
done
