#!/bin/bash

echo ""
echo ""
echo "#################################################"
echo "### Clear jbm                                 ###"
echo "###    Script start at `date '+%Y-%m-%d %T'`    ###"
echo "#################################################"
echo ""

## Hinemos env
. /opt/hinemos/hinemos.cfg

## Version
VER=`cat ${HINEMOS_HOME}/_version`
VER_MJ=`echo ${VER} | cut -c1-3`

echo "Installed Hinemos ver : ${VER}"
echo ""

## init valiable
HOST="localhost"
PGPORT=24001
LDAPPORT=24000
PSQLBIN="${PG}/bin/psql"
LDAPBIN="${LDAP}/bin/ldapsearch"
DBNAME=hinemos
USER=hinemos

PSQLCMD="${PSQLBIN} -h ${HOST} -p ${PGPORT} -U ${USER} -d ${DBNAME} "
PSQLCMD_NA="${PSQLBIN} -h ${HOST} -p ${PGPORT} -U ${USER} -d ${DBNAME} -A -t "

## postgresql password
## postgresql connect check
export PGPASSWORD="hinemos"
read -p "Postgres Password (default hinemos) : " PASSWD
if [ "${PASSWD}" != "" ] ; then
    export PGPASSWORD=${PASSWD}
fi
RESULT=`${PSQLCMD_NA} -c "SELECT 1;"`
EXIT_CODE=$?
if [ ${EXIT_CODE} -ne 0 ] ; then
    echo "Failed to access PostgreSQL" 1>&2
    echo "exit code ${EXIT_CODE}" 1>&2
    exit ${EXIT_CODE}
fi


echo "### Clear jbm_msg ###"
${PSQLCMD} -c "
    TRUNCATE jbm_msg;
"

echo "### Clear jbm_msg_ref ###"
${PSQLCMD} -c "
    TRUNCATE jbm_msg_ref;
"

echo "### Clear jbm_tx ###"
${PSQLCMD} -c "
    TRUNCATE jbm_tx;
"

echo "### remove tx-object-store ###"
rm -rf ${JBOSS_HOME}/server/default/data/tx-object-store

echo "#################################################"
echo "###     Script end at `date '+%Y-%m-%d %T'`     ###"
echo "#################################################"

