/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.monitor.factory;

import com.clustercontrol.monitor.run.factory.RunMonitor;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.performance.bean.CollectedDataInfo;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performance.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performance.util.code.CollectorItemCodeTable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunMonitorPerformance2
extends RunMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(RunMonitorPerformance2.class);
    public static final String MESSAGE_ID_INFO = "001";
    public static final String MESSAGE_ID_WARNING = "002";
    public static final String MESSAGE_ID_CRITICAL = "003";
    public static final String MESSAGE_ID_UNKNOWN = "004";
    protected MonitorPerfInfoLocal m_perf = null;
    private String m_itemName = null;
    protected NumberFormat m_numberFormat = NumberFormat.getNumberInstance();

    public RunMonitor createMonitorInstance() throws NamingException, JMSException, CreateException {
        return new RunMonitorPerformance2();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(String monitorTypeId, String monitorId, CollectedDataInfo data) throws FinderException, RemoveException, JMSException, NamingException, CreateException {
        block22: {
            block21: {
                block20: {
                    block19: {
                        try {
                            try {
                                String facilityId;
                                block24: {
                                    block23: {
                                        super.initialize();
                                        facilityId = data.getFacilityId();
                                        if (facilityId == null) break block23;
                                        if (!"".equals(facilityId)) break block24;
                                    }
                                    Object var10_9 = null;
                                    break block19;
                                }
                                if (this.m_repository.getExecTargetFacilityIdList(facilityId).size() == 0) {
                                    break block20;
                                }
                                this.m_value = (float)data.getValue();
                                this.m_now = new Date();
                                this.m_monitorTypeId = monitorTypeId;
                                this.m_monitorId = monitorId;
                                this.m_priorityMap = new HashMap();
                                this.m_priorityMap.put(3, new ArrayList());
                                this.m_priorityMap.put(2, new ArrayList());
                                this.m_priorityMap.put(0, new ArrayList());
                                this.m_priorityMap.put(1, new ArrayList());
                                boolean notify = this.setMonitorInfo(this.m_monitorTypeId, this.m_monitorId);
                                if (!notify) {
                                    break block21;
                                }
                                this.setJudgementInfo();
                                this.setCheckInfo();
                                boolean isNode = false;
                                if (this.m_repository.isNode(this.m_facilityId)) {
                                    isNode = true;
                                }
                                boolean result = this.collect(facilityId);
                                int priority = this.getCheckResult(result);
                                if (this.m_repository.isNode(facilityId)) {
                                    if (0 == this.m_monitorBlock || 1 == this.m_monitorBlock && isNode || 2 == this.m_monitorBlock) {
                                        if (data.getDate().getTime() == 0L) {
                                            this.notify(true, facilityId, priority, new Date());
                                            break block22;
                                        } else {
                                            this.notify(true, facilityId, priority, data.getDate());
                                        }
                                    }
                                    break block22;
                                }
                                if (1 != this.m_monitorBlock && 2 != this.m_monitorBlock) break block22;
                                if (data.getDate().getTime() == 0L) {
                                    this.notify(false, facilityId, priority, new Date());
                                    break block22;
                                } else {
                                    this.notify(false, facilityId, priority, data.getDate());
                                }
                                break block22;
                            }
                            catch (FinderException e) {
                                m_log.error((Object)("run():" + e.getMessage()));
                                e.printStackTrace();
                                throw e;
                            }
                            catch (JMSException e) {
                                e.printStackTrace();
                                throw e;
                            }
                            catch (NamingException e) {
                                m_log.error((Object)("run():" + e.getMessage()));
                                e.printStackTrace();
                                throw e;
                            }
                            catch (CreateException e) {
                                m_log.error((Object)("run():" + e.getMessage()));
                                e.printStackTrace();
                                throw e;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            this.terminate();
                            throw throwable;
                        }
                    }
                    this.terminate();
                    return;
                }
                Object var10_10 = null;
                this.terminate();
                return;
            }
            Object var10_11 = null;
            this.terminate();
            return;
        }
        Object var10_12 = null;
        this.terminate();
    }

    public void setCheckInfo() throws FinderException, NamingException {
        MonitorPerfInfoPK pk = new MonitorPerfInfoPK(this.m_monitorId, this.m_monitorTypeId);
        this.m_perf = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
        this.m_itemName = CollectorItemCodeTable.getFullItemName(this.m_perf.getItemCode(), this.m_perf.getDeviceName());
    }

    public String getMessageId(int result) {
        if (result == 3) {
            return MESSAGE_ID_INFO;
        }
        if (result == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (result == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessageIdForScope(int priority) {
        if (priority == 3) {
            return MESSAGE_ID_INFO;
        }
        if (priority == 2) {
            return MESSAGE_ID_WARNING;
        }
        if (priority == 0) {
            return MESSAGE_ID_CRITICAL;
        }
        return MESSAGE_ID_UNKNOWN;
    }

    public String getMessage(int result) {
        String valueString = Double.isNaN(this.m_value) ? "NaN" : this.m_numberFormat.format(this.m_value);
        return this.m_itemName + " : " + valueString;
    }

    public String getMessageForScope(int result) {
        String valueString = Double.isNaN(this.m_value) ? "NaN" : this.m_numberFormat.format(this.m_value);
        return this.m_itemName + " : " + valueString;
    }

    public String getMessageOrg(int result) {
        String valueString = Double.isNaN(this.m_value) ? "NaN" : this.m_numberFormat.format(this.m_value);
        return this.m_itemName + " : " + valueString;
    }

    public String getMessageOrgForScope(int result) {
        String valueString = Double.isNaN(this.m_value) ? "NaN" : this.m_numberFormat.format(this.m_value);
        return this.m_itemName + " : " + valueString;
    }

    public boolean collect(String facilityId) {
        return !Double.isNaN(this.m_value);
    }
}

