/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.util;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoPK;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogLocal;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogUtil;
import com.clustercontrol.notify.monitor.ejb.entity.EventMultiInfoLocal;
import com.clustercontrol.notify.monitor.ejb.entity.EventMultiInfoUtil;
import com.clustercontrol.notify.util.InhibitAction;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputEvent
extends InhibitAction {
    protected static Log m_log = LogFactory.getLog(OutputEvent.class);
    private boolean m_insertMultiFlg;
    private boolean m_updateMultiFlg;
    private boolean m_isControlEvent;
    private boolean m_isControlPriority;
    private boolean m_isInhibit;
    private SendQueue m_queue;

    public synchronized void outputEvent(OutputNotifyGroupInfo outputInfo) throws RemoteException, NamingException, CreateException, FinderException {
        if (outputInfo.getNotifyGroupId() != null && !outputInfo.getNotifyGroupId().equals("")) {
            NotifyInfoLocal notifyInfo = NotifyInfoUtil.getLocalHome().findByPrimaryKey(outputInfo.getNotifyId());
            NotifyEventInfoLocal notifyEventInfo = NotifyEventInfoUtil.getLocalHome().findByPrimaryKey(new NotifyEventInfoPK(outputInfo.getNotifyId(), outputInfo.getPriority()));
            if (notifyEventInfo == null) {
                m_log.debug((Object)"insertEventLog() : \u51fa\u529b\u3059\u308b\u91cd\u8981\u5ea6\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                return;
            }
            if (notifyEventInfo.getEventNormalFlg() == 1) {
                if (outputInfo.getMultiId() == null) {
                    // empty if block
                }
                this.m_isControlEvent = false;
                this.m_isControlPriority = false;
                this.m_isInhibit = false;
                if (notifyInfo.getInhibitionFlg() != 0) {
                    this.m_isControlEvent = true;
                    if (notifyEventInfo.getEventInhibitionFlg() == 1) {
                        this.m_isControlPriority = true;
                        try {
                            this.m_isInhibit = this.isInhibit(outputInfo, notifyInfo);
                        }
                        catch (NumberFormatException e) {
                            m_log.error((Object)("outputEvent() : " + e.getMessage()), (Throwable)e);
                        }
                        catch (RemoteException e) {
                            m_log.error((Object)("outputEvent() : " + e.getMessage()), (Throwable)e);
                        }
                        catch (CreateException e) {
                            m_log.error((Object)("outputEvent() : " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                if (this.m_isInhibit) {
                    if (notifyEventInfo.getEventInhibitionState() != 2) {
                        this.insertEventLog(outputInfo, notifyEventInfo, 1);
                    } else if (this.m_isControlEvent) {
                        if (this.m_isControlPriority) {
                            this.inhibitUpdate(this.m_isInhibit, outputInfo);
                        } else {
                            this.updateLastUpdateDate(outputInfo, notifyInfo.getNotifyId());
                        }
                    }
                } else {
                    this.insertEventLog(outputInfo, notifyEventInfo, 0);
                }
            }
        } else {
            this.insertEventLog(outputInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEventLog(OutputNotifyGroupInfo output, NotifyEventInfoLocal eventInfo, int inhibitedFlg) throws NamingException, CreateException, RemoteException {
        block19: {
            try {
                int eventState = -1;
                eventState = inhibitedFlg == 1 && eventInfo.getEventInhibitionFlg() == 1 ? eventInfo.getEventInhibitionState().intValue() : eventInfo.getEventNormalState().intValue();
                EventLogUtil.getLocalHome().create(output.getMonitorId(), output.getPluginId(), output.getFacilityId(), output.getScopeText(), output.getApplication(), output.getMessageId(), output.getMessage(), output.getMessageOrg(), new Integer(output.getPriority()), new Integer(eventState), null, "", new Integer(0), new Timestamp(output.getGenerationDate().getTime()), new Timestamp(new Date().getTime()), new Integer(inhibitedFlg));
                if (this.m_isControlEvent) {
                    if (this.m_isControlPriority) {
                        this.inhibitUpdate(this.m_isInhibit, output);
                    } else {
                        this.updateLastUpdateDate(output, eventInfo.getNotifyId());
                    }
                }
            }
            catch (NamingException e) {
                throw e;
            }
            catch (CreateException e) {
                if (e instanceof DuplicateKeyException) {
                    Date now = new Date();
                    output.setOutputDate(new Timestamp(now.getTime()));
                    try {
                        this.m_queue = new SendQueue("queue/clustercontrolNotifyEvent");
                        this.m_queue.put((Serializable)output);
                    }
                    catch (JMSException e1) {
                        m_log.error((Object)e1.getMessage(), (Throwable)e1);
                        break block19;
                    }
                    finally {
                        try {
                            if (this.m_queue != null) {
                                this.m_queue.terminate();
                            }
                            this.m_queue = null;
                        }
                        catch (JMSException e1) {
                            m_log.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertEventLog(OutputNotifyGroupInfo output) throws NamingException, CreateException {
        block16: {
            try {
                Timestamp outputDate = null;
                outputDate = output.getOutputDate() != null && !output.getOutputDate().equals("") ? output.getOutputDate() : new Timestamp(new Date().getTime());
                EventLogUtil.getLocalHome().create(output.getMonitorId(), output.getPluginId(), output.getFacilityId(), output.getScopeText(), output.getApplication(), output.getMessageId(), output.getMessage(), output.getMessageOrg(), new Integer(output.getPriority()), new Integer(0), null, "", new Integer(0), new Timestamp(output.getGenerationDate().getTime()), outputDate, new Integer(0));
            }
            catch (NamingException e) {
                throw e;
            }
            catch (CreateException e) {
                if (e instanceof DuplicateKeyException) {
                    Date now = new Date();
                    output.setOutputDate(new Timestamp(now.getTime()));
                    try {
                        this.m_queue = new SendQueue("queue/clustercontrolNotifyEvent");
                        this.m_queue.put((Serializable)output);
                    }
                    catch (JMSException e1) {
                        m_log.error((Object)e1.getMessage(), (Throwable)e1);
                        break block16;
                    }
                    finally {
                        try {
                            if (this.m_queue != null) {
                                this.m_queue.terminate();
                            }
                            this.m_queue = null;
                        }
                        catch (JMSException e1) {
                            m_log.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
                throw e;
            }
        }
    }

    public void insertEventMultiInfo(OutputNotifyGroupInfo outputInfo) throws NamingException, CreateException {
        try {
            EventMultiInfoUtil.getLocalHome().create(outputInfo.getMonitorId(), outputInfo.getPluginId(), outputInfo.getFacilityId(), outputInfo.getOutputDate(), outputInfo.getMultiId(), 0);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (CreateException e) {
            throw e;
        }
    }

    public void updateEventLog(EventLogLocal eventLog) throws EJBException {
        if (eventLog != null) {
            eventLog.setDuplicationCount(new Integer(eventLog.getDuplicationCount() + 1));
        }
    }

    public void updateEventMultiInfo(EventMultiInfoLocal EventMultiInfo2) throws EJBException {
        if (EventMultiInfo2 != null) {
            EventMultiInfo2.setDuplicationCount(new Integer(EventMultiInfo2.getDuplicationCount() + 1));
        }
    }

    private void updateLastUpdateDate(OutputNotifyGroupInfo outputInfo, String notifyId) throws NamingException {
        try {
            NotifyActionInhibitionInfoLocal inhibition = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(new NotifyActionInhibitionInfoPK(outputInfo.getNotifyGroupId(), notifyId, outputInfo.getFacilityId()));
            inhibition.setLastUpdateDate(new Timestamp(outputInfo.getGenerationDate().getTime()));
            inhibition.setPriority(outputInfo.getPriority());
        }
        catch (FinderException e) {
            return;
        }
    }

    protected boolean isInhibit(OutputNotifyGroupInfo outputInfo, NotifyInfoLocal notifyInfo) throws RemoteException, NamingException, NumberFormatException, CreateException {
        boolean isInhibit = false;
        this.m_notifyInfo = notifyInfo;
        String notifyGroupId = outputInfo.getNotifyGroupId();
        String notifyId = notifyInfo.getNotifyId();
        String facilityId = outputInfo.getFacilityId();
        int priority = outputInfo.getPriority();
        Date generationDate = outputInfo.getGenerationDate();
        NotifyActionInhibitionInfoPK inhibitionPk = new NotifyActionInhibitionInfoPK(notifyGroupId, notifyId, facilityId);
        try {
            this.m_inhibitInfo = NotifyActionInhibitionInfoUtil.getLocalHome().findByPrimaryKey(inhibitionPk);
        }
        catch (FinderException e) {
            this.m_inhibitInfo = null;
            return false;
        }
        if (notifyInfo.getInhibitionFlg() == 2) {
            isInhibit = this.isInhibitPeriod(generationDate);
        } else if (notifyInfo.getInhibitionFlg() == 1) {
            isInhibit = this.isInhibitFrequency();
        } else if (notifyInfo.getInhibitionFlg() == 3) {
            isInhibit = this.isInhibitPriority(priority);
        } else {
            m_log.debug((Object)"inhibit() : \u3069\u306e\u6291\u5236\u30bf\u30a4\u30d7\u306b\u3082\u5f53\u3066\u306f\u307e\u308a\u307e\u305b\u3093\u3002");
            return false;
        }
        return isInhibit;
    }

    protected void inhibitUpdate(boolean isInhibit, OutputNotifyGroupInfo output) throws CreateException, NamingException {
        if (this.m_inhibitInfo != null) {
            this.m_inhibitInfo.setPriority(output.getPriority());
            this.m_inhibitInfo.setTotalCount(this.m_inhibitInfo.getTotalCount() + 1L);
            this.m_inhibitInfo.setLastUpdateDate(new Timestamp(output.getGenerationDate().getTime()));
            if (isInhibit) {
                this.m_inhibitInfo.setDupuricationCount(this.m_inhibitInfo.getDupuricationCount() + 1L);
            } else {
                this.m_inhibitInfo.setLastNotifyDate(new Timestamp(output.getGenerationDate().getTime()));
                this.m_inhibitInfo.setDupuricationCount(new Long(0L));
            }
        } else {
            NotifyActionInhibitionInfoUtil.getLocalHome().create(output.getNotifyGroupId(), output.getNotifyId(), output.getFacilityId(), output.getPriority(), new Timestamp(output.getGenerationDate().getTime()), new Timestamp(output.getGenerationDate().getTime()), new Long(0L), new Long(1L));
        }
    }
}

