/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.poller.snmp.job;

import com.clustercontrol.poller.snmp.SnmpPoller;
import com.clustercontrol.poller.snmp.SnmpPollerManager;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class SnmpPollingJob
implements Job {
    private static Log m_log = LogFactory.getLog(SnmpPollingJob.class);
    private static final ConcurrentHashMap<Long, PollingThreadInfo> activePollingThreadInfoMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        m_log.debug((Object)"execute start : ");
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String jndiName = dataMap.getString("jndiName");
        String pollerGroup = dataMap.getString("pollerGroup");
        String pollerName = dataMap.getString("pollerName");
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(jndiName);
            SnmpPollerManager manager = (SnmpPollerManager)PortableRemoteObject.narrow((Object)obj, SnmpPollerManager.class);
            SnmpPoller poller = manager.getPoller(pollerGroup, pollerName);
            int timeout_min = 60;
            for (PollingThreadInfo threadInfo : activePollingThreadInfoMap.values()) {
                if (System.currentTimeMillis() - 3600000L <= threadInfo.getStartTime() || threadInfo.getIsLogged()) continue;
                String longPollerGroup = threadInfo.getPollerGroup();
                String longPollerName = threadInfo.getPollerName();
                threadInfo.setIsLogged();
                int currentThreadCount = activePollingThreadInfoMap.size();
                int longThreadCount = 0;
                for (PollingThreadInfo tmpInfo : activePollingThreadInfoMap.values()) {
                    if (!tmpInfo.getIsLogged()) continue;
                    ++longThreadCount;
                }
                AplLogger apllog = new AplLogger("COMMON", "common");
                Object[] args = new String[]{Integer.toString(60), longPollerGroup, longPollerName, Integer.toString(longThreadCount), Integer.toString(currentThreadCount)};
                apllog.put("SYS", "001", args);
            }
            activePollingThreadInfoMap.put(Thread.currentThread().getId(), new PollingThreadInfo(pollerGroup, pollerName));
            poller.run();
        }
        catch (NamingException e) {
            m_log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            activePollingThreadInfoMap.remove(Thread.currentThread().getId());
        }
        m_log.debug((Object)("execute end   : " + jndiName));
    }

    private class PollingThreadInfo {
        private final long startTime = System.currentTimeMillis();
        private final String threadName;
        private final String pollerGroup;
        private final String pollerName;
        private volatile boolean isLogged = false;

        public PollingThreadInfo(String pollerGroup, String pollerName) {
            this.pollerGroup = pollerGroup;
            this.pollerName = pollerName;
            this.threadName = Thread.currentThread().getName();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public String getPollerGroup() {
            return this.pollerGroup;
        }

        public String getPollerName() {
            return this.pollerName;
        }

        public boolean getIsLogged() {
            return this.isLogged;
        }

        public void setIsLogged() {
            this.isLogged = true;
        }
    }
}

