/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.OptimisticTransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;

public class OptimisticInterceptor
extends Interceptor {
    protected TransactionManager txManager = null;
    protected TransactionTable txTable = null;

    public void setCache(TreeCache cache) {
        this.cache = cache;
        this.txManager = cache.getTransactionManager();
        this.txTable = cache.getTransactionTable();
    }

    protected TransactionWorkspace getTransactionWorkspace(GlobalTransaction gtx) throws CacheException {
        OptimisticTransactionEntry transactionEntry = (OptimisticTransactionEntry)this.txTable.get(gtx);
        if (transactionEntry == null) {
            throw new CacheException("unable to map global transaction " + gtx + " to transaction entry");
        }
        return transactionEntry.getTransactionWorkSpace();
    }
}

